/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DataCategory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeItem;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryItemType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.AtomicClientReportStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.ClientReport;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.ClientReportKey;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.DiscardReason;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.DiscardedEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.IClientReportRecorder;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.IClientReportStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentrySpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryTransaction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClientReportRecorder
implements IClientReportRecorder {
    @NotNull
    private final IClientReportStorage storage;
    @NotNull
    private final SentryOptions options;

    public ClientReportRecorder(@NotNull SentryOptions options2) {
        this.options = options2;
        this.storage = new AtomicClientReportStorage();
    }

    @Override
    @NotNull
    public SentryEnvelope attachReportToEnvelope(@NotNull SentryEnvelope envelope) {
        @Nullable ClientReport clientReport = this.resetCountsAndGenerateClientReport();
        if (clientReport == null) {
            return envelope;
        }
        try {
            this.options.getLogger().log(SentryLevel.DEBUG, "Attaching client report to envelope.", new Object[0]);
            ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item2 : envelope.getItems()) {
                items.add(item2);
            }
            items.add(SentryEnvelopeItem.fromClientReport(this.options.getSerializer(), clientReport));
            return new SentryEnvelope(envelope.getHeader(), items);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to attach client report to envelope.", new Object[0]);
            return envelope;
        }
    }

    @Override
    public void recordLostEnvelope(@NotNull DiscardReason reason2, @Nullable SentryEnvelope envelope) {
        if (envelope == null) {
            return;
        }
        try {
            for (SentryEnvelopeItem item2 : envelope.getItems()) {
                this.recordLostEnvelopeItem(reason2, item2);
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to record lost envelope.", new Object[0]);
        }
    }

    @Override
    public void recordLostEnvelopeItem(@NotNull DiscardReason reason2, @Nullable SentryEnvelopeItem envelopeItem) {
        if (envelopeItem == null) {
            return;
        }
        try {
            @NotNull SentryItemType itemType = envelopeItem.getHeader().getType();
            if (SentryItemType.ClientReport.equals(itemType)) {
                try {
                    ClientReport clientReport = envelopeItem.getClientReport(this.options.getSerializer());
                    this.restoreCountsFromClientReport(clientReport);
                }
                catch (Exception e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Unable to restore counts from previous client report.", new Object[0]);
                }
            } else {
                SentryTransaction transaction;
                @NotNull DataCategory itemCategory = this.categoryFromItemType(itemType);
                if (itemCategory.equals((Object)DataCategory.Transaction) && (transaction = envelopeItem.getTransaction(this.options.getSerializer())) != null) {
                    @NotNull List<SentrySpan> spans = transaction.getSpans();
                    this.recordLostEventInternal(reason2.getReason(), DataCategory.Span.getCategory(), (long)spans.size() + 1L);
                }
                this.recordLostEventInternal(reason2.getReason(), itemCategory.getCategory(), 1L);
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to record lost envelope item.", new Object[0]);
        }
    }

    @Override
    public void recordLostEvent(@NotNull DiscardReason reason2, @NotNull DataCategory category) {
        this.recordLostEvent(reason2, category, 1L);
    }

    @Override
    public void recordLostEvent(@NotNull DiscardReason reason2, @NotNull DataCategory category, long count2) {
        try {
            this.recordLostEventInternal(reason2.getReason(), category.getCategory(), count2);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to record lost event.", new Object[0]);
        }
    }

    private void recordLostEventInternal(@NotNull String reason2, @NotNull String category, @NotNull Long countToAdd) {
        ClientReportKey key = new ClientReportKey(reason2, category);
        this.storage.addCount(key, countToAdd);
    }

    @Nullable
    ClientReport resetCountsAndGenerateClientReport() {
        Date currentDate = DateUtils.getCurrentDateTime();
        List<DiscardedEvent> discardedEvents = this.storage.resetCountsAndGet();
        if (discardedEvents.isEmpty()) {
            return null;
        }
        return new ClientReport(currentDate, discardedEvents);
    }

    private void restoreCountsFromClientReport(@Nullable ClientReport clientReport) {
        if (clientReport == null) {
            return;
        }
        for (DiscardedEvent discardedEvent : clientReport.getDiscardedEvents()) {
            this.recordLostEventInternal(discardedEvent.getReason(), discardedEvent.getCategory(), discardedEvent.getQuantity());
        }
    }

    private DataCategory categoryFromItemType(SentryItemType itemType) {
        if (SentryItemType.Event.equals(itemType)) {
            return DataCategory.Error;
        }
        if (SentryItemType.Session.equals(itemType)) {
            return DataCategory.Session;
        }
        if (SentryItemType.Transaction.equals(itemType)) {
            return DataCategory.Transaction;
        }
        if (SentryItemType.UserFeedback.equals(itemType)) {
            return DataCategory.UserReport;
        }
        if (SentryItemType.Feedback.equals(itemType)) {
            return DataCategory.Feedback;
        }
        if (SentryItemType.Profile.equals(itemType)) {
            return DataCategory.Profile;
        }
        if (SentryItemType.ProfileChunk.equals(itemType)) {
            return DataCategory.ProfileChunkUi;
        }
        if (SentryItemType.Attachment.equals(itemType)) {
            return DataCategory.Attachment;
        }
        if (SentryItemType.CheckIn.equals(itemType)) {
            return DataCategory.Monitor;
        }
        if (SentryItemType.ReplayVideo.equals(itemType)) {
            return DataCategory.Replay;
        }
        if (SentryItemType.Log.equals(itemType)) {
            return DataCategory.LogItem;
        }
        return DataCategory.Default;
    }
}

