/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config.PropertiesProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompositePropertiesProvider
implements PropertiesProvider {
    @NotNull
    private final List<PropertiesProvider> providers;

    public CompositePropertiesProvider(@NotNull List<PropertiesProvider> providers) {
        this.providers = providers;
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String property2) {
        for (PropertiesProvider provider : this.providers) {
            String result2 = provider.getProperty(property2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> getMap(@NotNull String property2) {
        ConcurrentHashMap<String, String> result2 = new ConcurrentHashMap<String, String>();
        for (PropertiesProvider provider : this.providers) {
            result2.putAll(provider.getMap(property2));
        }
        return result2;
    }
}

