/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertiesProvider {
    @Nullable
    public String getProperty(@NotNull String var1);

    @NotNull
    public Map<String, String> getMap(@NotNull String var1);

    @NotNull
    default public List<String> getList(@NotNull String property2) {
        String value2 = this.getProperty(property2);
        return value2 != null ? Arrays.asList(value2.split(",")) : Collections.emptyList();
    }

    @Nullable
    default public List<String> getListOrNull(@NotNull String property2) {
        String value2 = this.getProperty(property2);
        return value2 != null ? Arrays.asList(value2.split(",")) : null;
    }

    @NotNull
    default public String getProperty(@NotNull String property2, @NotNull String defaultValue) {
        String result2 = this.getProperty(property2);
        return result2 != null ? result2 : defaultValue;
    }

    @Nullable
    default public Boolean getBooleanProperty(@NotNull String property2) {
        String result2 = this.getProperty(property2);
        return result2 != null ? Boolean.valueOf(result2) : null;
    }

    @Nullable
    default public Double getDoubleProperty(@NotNull String property2) {
        String prop = this.getProperty(property2);
        Double result2 = null;
        if (prop != null) {
            try {
                result2 = Double.valueOf(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result2;
    }

    @Nullable
    default public Long getLongProperty(@NotNull String property2) {
        String prop = this.getProperty(property2);
        Long result2 = null;
        if (prop != null) {
            try {
                result2 = Long.valueOf(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result2;
    }
}

