/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryIntegrationPackageStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryPackage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.AutoClosableReentrantLock;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ManifestVersionReader {
    @Nullable
    private static volatile ManifestVersionReader INSTANCE;
    @NotNull
    private static final AutoClosableReentrantLock staticLock;
    private volatile boolean hasManifestBeenRead = false;
    @Nullable
    private volatile VersionInfoHolder versionInfo = null;
    @NotNull
    private AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    @NotNull
    public static ManifestVersionReader getInstance() {
        if (INSTANCE == null) {
            try (@NotNull ISentryLifecycleToken ignored = staticLock.acquire();){
                if (INSTANCE == null) {
                    INSTANCE = new ManifestVersionReader();
                }
            }
        }
        return INSTANCE;
    }

    private ManifestVersionReader() {
    }

    @Nullable
    public VersionInfoHolder readOpenTelemetryVersion() {
        this.readManifestFiles();
        return this.versionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readManifestFiles() {
        if (this.hasManifestBeenRead) {
            return;
        }
        @Nullable VersionInfoHolder infoHolder = null;
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.hasManifestBeenRead) {
                return;
            }
            @NotNull Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try {
                    @NotNull Manifest manifest = new Manifest(resources.nextElement().openStream());
                    @Nullable Attributes mainAttributes = manifest.getMainAttributes();
                    if (mainAttributes == null) continue;
                    @Nullable String name2 = mainAttributes.getValue("Sentry-Opentelemetry-SDK-Name");
                    @Nullable String version = mainAttributes.getValue("Implementation-Version");
                    @Nullable String sdkName = mainAttributes.getValue("Sentry-SDK-Name");
                    @Nullable String packageName = mainAttributes.getValue("Sentry-SDK-Package-Name");
                    if (name2 != null && version != null) {
                        String otelJavaagentVersion;
                        infoHolder = new VersionInfoHolder();
                        infoHolder.sdkName = name2;
                        infoHolder.sdkVersion = version;
                        infoHolder.packages.add(new SentryPackage("maven:io.sentry:sentry-opentelemetry-agent", version));
                        @Nullable String otelVersion = mainAttributes.getValue("Sentry-Opentelemetry-Version-Name");
                        if (otelVersion != null) {
                            infoHolder.packages.add(new SentryPackage("maven:io.opentelemetry:opentelemetry-sdk", otelVersion));
                            infoHolder.integrations.add("OpenTelemetry");
                        }
                        if ((otelJavaagentVersion = mainAttributes.getValue("Sentry-Opentelemetry-Javaagent-Version-Name")) != null) {
                            infoHolder.packages.add(new SentryPackage("maven:io.opentelemetry.javaagent:opentelemetry-javaagent", otelJavaagentVersion));
                            infoHolder.integrations.add("OpenTelemetry-Agent");
                        }
                        break;
                    }
                    if (sdkName == null || version == null || packageName == null || !sdkName.startsWith("sentry.java")) continue;
                    SentryIntegrationPackageStorage.getInstance().addPackage(packageName, version);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.hasManifestBeenRead = true;
            this.versionInfo = infoHolder;
        }
    }

    static {
        staticLock = new AutoClosableReentrantLock();
    }

    public static final class VersionInfoHolder {
        @Nullable
        private String sdkName;
        @Nullable
        private String sdkVersion;
        private List<SentryPackage> packages = new ArrayList<SentryPackage>();
        private List<String> integrations = new ArrayList<String>();

        @Nullable
        public String getSdkName() {
            return this.sdkName;
        }

        @Nullable
        public String getSdkVersion() {
            return this.sdkVersion;
        }

        public List<SentryPackage> getPackages() {
            return this.packages;
        }

        public List<String> getIntegrations() {
            return this.integrations;
        }
    }
}

