/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.logger;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.HostnameCache;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.PropagationContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Scopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryAttribute;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryAttributeType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryAttributes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryDate;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogEventAttributeValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.logger.ILoggerApi;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.logger.SentryLogParameters;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkVersion;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Platform;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.TracingUtils;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class LoggerApi
implements ILoggerApi {
    @NotNull
    private final Scopes scopes;

    public LoggerApi(@NotNull Scopes scopes) {
        this.scopes = scopes;
    }

    @Override
    public void trace(@Nullable String message2, Object ... args) {
        this.log(SentryLogLevel.TRACE, message2, args);
    }

    @Override
    public void debug(@Nullable String message2, Object ... args) {
        this.log(SentryLogLevel.DEBUG, message2, args);
    }

    @Override
    public void info(@Nullable String message2, Object ... args) {
        this.log(SentryLogLevel.INFO, message2, args);
    }

    @Override
    public void warn(@Nullable String message2, Object ... args) {
        this.log(SentryLogLevel.WARN, message2, args);
    }

    @Override
    public void error(@Nullable String message2, Object ... args) {
        this.log(SentryLogLevel.ERROR, message2, args);
    }

    @Override
    public void fatal(@Nullable String message2, Object ... args) {
        this.log(SentryLogLevel.FATAL, message2, args);
    }

    @Override
    public void log(@NotNull SentryLogLevel level, @Nullable String message2, Object ... args) {
        this.captureLog(level, SentryLogParameters.create(null, null), message2, args);
    }

    @Override
    public void log(@NotNull SentryLogLevel level, @Nullable SentryDate timestamp2, @Nullable String message2, Object ... args) {
        this.captureLog(level, SentryLogParameters.create(timestamp2, null), message2, args);
    }

    @Override
    public void log(@NotNull SentryLogLevel level, @NotNull SentryLogParameters params, @Nullable String message2, Object ... args) {
        this.captureLog(level, params, message2, args);
    }

    private void captureLog(@NotNull SentryLogLevel level, @NotNull SentryLogParameters params, @Nullable String message2, Object ... args) {
        @NotNull SentryOptions options2 = this.scopes.getOptions();
        try {
            if (!this.scopes.isEnabled()) {
                options2.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'logger' call is a no-op.", new Object[0]);
                return;
            }
            if (!options2.getLogs().isEnabled()) {
                options2.getLogger().log(SentryLevel.WARNING, "Sentry Log is disabled and this 'logger' call is a no-op.", new Object[0]);
                return;
            }
            if (message2 == null) {
                return;
            }
            @Nullable SentryDate timestamp2 = params.getTimestamp();
            @NotNull SentryDate timestampToUse = timestamp2 == null ? options2.getDateProvider().now() : timestamp2;
            @NotNull String messageToUse = this.maybeFormatMessage(message2, args);
            @NotNull IScope combinedScope = this.scopes.getCombinedScopeView();
            @NotNull PropagationContext propagationContext = combinedScope.getPropagationContext();
            @Nullable ISpan span = combinedScope.getSpan();
            if (span == null) {
                TracingUtils.maybeUpdateBaggage(combinedScope, options2);
            }
            @NotNull SentryId traceId = span == null ? propagationContext.getTraceId() : span.getSpanContext().getTraceId();
            @NotNull SpanId spanId = span == null ? propagationContext.getSpanId() : span.getSpanContext().getSpanId();
            SentryLogEvent logEvent = new SentryLogEvent(traceId, timestampToUse, messageToUse, level);
            logEvent.setAttributes(this.createAttributes(params.getAttributes(), message2, spanId, args));
            logEvent.setSeverityNumber(level.getSeverityNumber());
            this.scopes.getClient().captureLog(logEvent, combinedScope);
        }
        catch (Throwable e) {
            options2.getLogger().log(SentryLevel.ERROR, "Error while capturing log event", e);
        }
    }

    @NotNull
    private String maybeFormatMessage(@NotNull String message2, @Nullable Object[] args) {
        if (args == null || args.length == 0) {
            return message2;
        }
        try {
            return String.format(message2, args);
        }
        catch (Throwable t) {
            this.scopes.getOptions().getLogger().log(SentryLevel.ERROR, "Error while running log through String.format", t);
            return message2;
        }
    }

    @NotNull
    private HashMap<String, SentryLogEventAttributeValue> createAttributes(@Nullable SentryAttributes incomingAttributes, @NotNull String message2, @NotNull SpanId spanId, Object ... args) {
        String release;
        String string;
        SdkVersion sdkVersion;
        @NotNull HashMap<String, SentryLogEventAttributeValue> attributes = new HashMap<String, SentryLogEventAttributeValue>();
        if (incomingAttributes != null) {
            for (SentryAttribute sentryAttribute : incomingAttributes.getAttributes().values()) {
                @Nullable Object value2 = sentryAttribute.getValue();
                @NotNull SentryAttributeType type = sentryAttribute.getType() == null ? this.getType(value2) : sentryAttribute.getType();
                attributes.put(sentryAttribute.getName(), new SentryLogEventAttributeValue(type, value2));
            }
        }
        if (args != null) {
            int i = 0;
            for (Object arg : args) {
                @NotNull SentryAttributeType type = this.getType(arg);
                attributes.put("sentry.message.parameter." + i, new SentryLogEventAttributeValue(type, arg));
                ++i;
            }
            if (i > 0) {
                attributes.put("sentry.message.template", new SentryLogEventAttributeValue("string", (Object)message2));
            }
        }
        if ((sdkVersion = this.scopes.getOptions().getSdkVersion()) != null) {
            attributes.put("sentry.sdk.name", new SentryLogEventAttributeValue("string", (Object)sdkVersion.getName()));
            attributes.put("sentry.sdk.version", new SentryLogEventAttributeValue("string", (Object)sdkVersion.getVersion()));
        }
        if ((string = this.scopes.getOptions().getEnvironment()) != null) {
            attributes.put("sentry.environment", new SentryLogEventAttributeValue("string", (Object)string));
        }
        if ((release = this.scopes.getOptions().getRelease()) != null) {
            attributes.put("sentry.release", new SentryLogEventAttributeValue("string", (Object)release));
        }
        attributes.put("sentry.trace.parent_span_id", new SentryLogEventAttributeValue("string", (Object)spanId));
        if (Platform.isJvm()) {
            this.setServerName(attributes);
        }
        return attributes;
    }

    private void setServerName(@NotNull HashMap<String, SentryLogEventAttributeValue> attributes) {
        String hostname;
        @NotNull SentryOptions options2 = this.scopes.getOptions();
        @Nullable String optionsServerName = options2.getServerName();
        if (optionsServerName != null) {
            attributes.put("server.address", new SentryLogEventAttributeValue("string", (Object)optionsServerName));
        } else if (options2.isAttachServerName() && (hostname = HostnameCache.getInstance().getHostname()) != null) {
            attributes.put("server.address", new SentryLogEventAttributeValue("string", (Object)hostname));
        }
    }

    @NotNull
    private SentryAttributeType getType(@Nullable Object arg) {
        if (arg instanceof Boolean) {
            return SentryAttributeType.BOOLEAN;
        }
        if (arg instanceof Integer) {
            return SentryAttributeType.INTEGER;
        }
        if (arg instanceof Number) {
            return SentryAttributeType.DOUBLE;
        }
        return SentryAttributeType.STRING;
    }
}

