/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.opentelemetry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpLogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOpenTelemetryMode;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.LoadClass;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Platform;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.SpanUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class OpenTelemetryUtil {
    @ApiStatus.Internal
    public static void applyIgnoredSpanOrigins(@NotNull SentryOptions options2) {
        if (Platform.isJvm()) {
            @NotNull List<String> ignored = OpenTelemetryUtil.ignoredSpanOrigins(options2);
            for (String origin : ignored) {
                options2.addIgnoredSpanOrigin(origin);
            }
        }
    }

    @ApiStatus.Internal
    public static void updateOpenTelemetryModeIfAuto(@NotNull SentryOptions options2, @NotNull LoadClass loadClass) {
        if (!Platform.isJvm()) {
            return;
        }
        @NotNull SentryOpenTelemetryMode openTelemetryMode = options2.getOpenTelemetryMode();
        if (SentryOpenTelemetryMode.AUTO.equals((Object)openTelemetryMode)) {
            if (loadClass.isClassAvailable("io.github.quiltservertools.blockbotdiscord.libs.io.sentry.opentelemetry.agent.AgentMarker", NoOpLogger.getInstance())) {
                options2.getLogger().log(SentryLevel.DEBUG, "openTelemetryMode has been inferred from AUTO to AGENT", new Object[0]);
                options2.setOpenTelemetryMode(SentryOpenTelemetryMode.AGENT);
                return;
            }
            if (loadClass.isClassAvailable("io.github.quiltservertools.blockbotdiscord.libs.io.sentry.opentelemetry.agent.AgentlessMarker", NoOpLogger.getInstance())) {
                options2.getLogger().log(SentryLevel.DEBUG, "openTelemetryMode has been inferred from AUTO to AGENTLESS", new Object[0]);
                options2.setOpenTelemetryMode(SentryOpenTelemetryMode.AGENTLESS);
                return;
            }
            if (loadClass.isClassAvailable("io.github.quiltservertools.blockbotdiscord.libs.io.sentry.opentelemetry.agent.AgentlessSpringMarker", NoOpLogger.getInstance())) {
                options2.getLogger().log(SentryLevel.DEBUG, "openTelemetryMode has been inferred from AUTO to AGENTLESS_SPRING", new Object[0]);
                options2.setOpenTelemetryMode(SentryOpenTelemetryMode.AGENTLESS_SPRING);
                return;
            }
        }
    }

    @NotNull
    private static List<String> ignoredSpanOrigins(@NotNull SentryOptions options2) {
        @NotNull SentryOpenTelemetryMode openTelemetryMode = options2.getOpenTelemetryMode();
        if (SentryOpenTelemetryMode.OFF.equals((Object)openTelemetryMode)) {
            return Collections.emptyList();
        }
        return SpanUtils.ignoredSpanOriginsForOpenTelemetry(openTelemetryMode);
    }
}

