/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.profilemeasurements;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryDate;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryNanotimeDate;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ProfileMeasurementValue
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private Map<String, Object> unknown;
    @Nullable
    private Double timestamp;
    @NotNull
    private String relativeStartNs;
    private double value;

    public ProfileMeasurementValue() {
        this(0L, 0, new SentryNanotimeDate(new Date(0L), 0L));
    }

    public ProfileMeasurementValue(@NotNull Long relativeStartNs, @NotNull Number value2, @NotNull SentryDate timestamp2) {
        this.relativeStartNs = relativeStartNs.toString();
        this.value = value2.doubleValue();
        this.timestamp = DateUtils.nanosToSeconds(timestamp2.nanoTimestamp());
    }

    @Nullable
    public Double getTimestamp() {
        return this.timestamp;
    }

    public double getValue() {
        return this.value;
    }

    @NotNull
    public String getRelativeStartNs() {
        return this.relativeStartNs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileMeasurementValue that = (ProfileMeasurementValue)o;
        return Objects.equals(this.unknown, that.unknown) && this.relativeStartNs.equals(that.relativeStartNs) && this.value == that.value && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.unknown, this.relativeStartNs, this.value);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("value").value(logger, this.value);
        writer2.name("elapsed_since_start_ns").value(logger, this.relativeStartNs);
        if (this.timestamp != null) {
            writer2.name("timestamp").value(logger, this.doubleToBigDecimal(this.timestamp));
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @NotNull
    private BigDecimal doubleToBigDecimal(@NotNull Double value2) {
        return BigDecimal.valueOf(value2).setScale(6, RoundingMode.DOWN);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String VALUE = "value";
        public static final String START_NS = "elapsed_since_start_ns";
        public static final String TIMESTAMP = "timestamp";
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfileMeasurementValue> {
        @Override
        @NotNull
        public ProfileMeasurementValue deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            ProfileMeasurementValue data2 = new ProfileMeasurementValue();
            ConcurrentHashMap<String, Object> unknown = null;
            block12: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "value": {
                        Double value2 = reader2.nextDoubleOrNull();
                        if (value2 == null) continue block12;
                        data2.value = value2;
                        continue block12;
                    }
                    case "elapsed_since_start_ns": {
                        String startNs = reader2.nextStringOrNull();
                        if (startNs == null) continue block12;
                        data2.relativeStartNs = startNs;
                        continue block12;
                    }
                    case "timestamp": {
                        Double timestamp2;
                        try {
                            timestamp2 = reader2.nextDoubleOrNull();
                        }
                        catch (NumberFormatException e) {
                            Date date = reader2.nextDateOrNull(logger);
                            Double d = timestamp2 = date != null ? Double.valueOf(DateUtils.dateToSeconds(date)) : null;
                        }
                        if (timestamp2 == null) continue block12;
                        data2.timestamp = timestamp2;
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            data2.setUnknown(unknown);
            reader2.endObject();
            return data2;
        }
    }
}

