/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.DebugImage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkInfo;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugMeta
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private SdkInfo sdkInfo;
    @Nullable
    private List<DebugImage> images;
    @Nullable
    private Map<String, Object> unknown;

    @Nullable
    public List<DebugImage> getImages() {
        return this.images;
    }

    public void setImages(@Nullable List<DebugImage> images) {
        this.images = images != null ? new ArrayList<DebugImage>(images) : null;
    }

    @Nullable
    public SdkInfo getSdkInfo() {
        return this.sdkInfo;
    }

    public void setSdkInfo(@Nullable SdkInfo sdkInfo) {
        this.sdkInfo = sdkInfo;
    }

    @ApiStatus.Internal
    @Nullable
    public static DebugMeta buildDebugMeta(@Nullable DebugMeta eventDebugMeta, @NotNull SentryOptions options2) {
        @NotNull ArrayList<DebugImage> debugImages = new ArrayList<DebugImage>();
        if (options2.getProguardUuid() != null) {
            DebugImage proguardMappingImage = new DebugImage();
            proguardMappingImage.setType("proguard");
            proguardMappingImage.setUuid(options2.getProguardUuid());
            debugImages.add(proguardMappingImage);
        }
        for (String bundleId : options2.getBundleIds()) {
            DebugImage sourceBundleImage = new DebugImage();
            sourceBundleImage.setType("jvm");
            sourceBundleImage.setDebugId(bundleId);
            debugImages.add(sourceBundleImage);
        }
        if (!debugImages.isEmpty()) {
            DebugMeta debugMeta = eventDebugMeta;
            if (debugMeta == null) {
                debugMeta = new DebugMeta();
            }
            if (debugMeta.getImages() == null) {
                debugMeta.setImages(debugImages);
            } else {
                debugMeta.getImages().addAll(debugImages);
            }
            return debugMeta;
        }
        return null;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.sdkInfo != null) {
            writer2.name("sdk_info").value(logger, this.sdkInfo);
        }
        if (this.images != null) {
            writer2.name("images").value(logger, this.images);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String SDK_INFO = "sdk_info";
        public static final String IMAGES = "images";
    }

    public static final class Deserializer
    implements JsonDeserializer<DebugMeta> {
        @Override
        @NotNull
        public DebugMeta deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            DebugMeta debugMeta = new DebugMeta();
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block8: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "sdk_info": {
                        debugMeta.sdkInfo = reader2.nextOrNull(logger, new SdkInfo.Deserializer());
                        continue block8;
                    }
                    case "images": {
                        debugMeta.images = reader2.nextListOrNull(logger, new DebugImage.Deserializer());
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            debugMeta.setUnknown(unknown);
            return debugMeta;
        }
    }
}

