/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Feedback
implements JsonUnknown,
JsonSerializable {
    public static final String TYPE = "feedback";
    @NotNull
    private String message;
    @Nullable
    private String contactEmail;
    @Nullable
    private String name;
    @Nullable
    private SentryId associatedEventId;
    @Nullable
    private SentryId replayId;
    @Nullable
    private String url;
    @Nullable
    private Map<String, Object> unknown;

    public Feedback(@NotNull String message2) {
        this.setMessage(message2);
    }

    public Feedback(@NotNull Feedback feedback) {
        this.message = feedback.message;
        this.contactEmail = feedback.contactEmail;
        this.name = feedback.name;
        this.associatedEventId = feedback.associatedEventId;
        this.replayId = feedback.replayId;
        this.url = feedback.url;
        this.unknown = CollectionUtils.newConcurrentHashMap(feedback.unknown);
    }

    @Nullable
    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(@Nullable String contactEmail) {
        this.contactEmail = contactEmail;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name2) {
        this.name = name2;
    }

    @Nullable
    public SentryId getAssociatedEventId() {
        return this.associatedEventId;
    }

    public void setAssociatedEventId(@NotNull SentryId associatedEventId) {
        this.associatedEventId = associatedEventId;
    }

    @Nullable
    public SentryId getReplayId() {
        return this.replayId;
    }

    public void setReplayId(@NotNull SentryId replayId) {
        this.replayId = replayId;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url2) {
        this.url = url2;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@NotNull String message2) {
        this.message = message2.length() > 4096 ? message2.substring(0, 4096) : message2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Feedback)) {
            return false;
        }
        Feedback feedback = (Feedback)o;
        return Objects.equals(this.message, feedback.message) && Objects.equals(this.contactEmail, feedback.contactEmail) && Objects.equals(this.name, feedback.name) && Objects.equals(this.associatedEventId, feedback.associatedEventId) && Objects.equals(this.replayId, feedback.replayId) && Objects.equals(this.url, feedback.url) && Objects.equals(this.unknown, feedback.unknown);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.contactEmail, this.name, this.associatedEventId, this.replayId, this.url, this.unknown);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("message").value(this.message);
        if (this.contactEmail != null) {
            writer2.name("contact_email").value(this.contactEmail);
        }
        if (this.name != null) {
            writer2.name("name").value(this.name);
        }
        if (this.associatedEventId != null) {
            writer2.name("associated_event_id");
            this.associatedEventId.serialize(writer2, logger);
        }
        if (this.replayId != null) {
            writer2.name("replay_id");
            this.replayId.serialize(writer2, logger);
        }
        if (this.url != null) {
            writer2.name("url").value(this.url);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String MESSAGE = "message";
        public static final String CONTACT_EMAIL = "contact_email";
        public static final String NAME = "name";
        public static final String ASSOCIATED_EVENT_ID = "associated_event_id";
        public static final String REPLAY_ID = "replay_id";
        public static final String URL = "url";
    }

    public static final class Deserializer
    implements JsonDeserializer<Feedback> {
        @Override
        @NotNull
        public Feedback deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            @Nullable String message2 = null;
            String contactEmail = null;
            String name2 = null;
            SentryId associatedEventId = null;
            SentryId replayId = null;
            String url2 = null;
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block16: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "message": {
                        message2 = reader2.nextStringOrNull();
                        continue block16;
                    }
                    case "contact_email": {
                        contactEmail = reader2.nextStringOrNull();
                        continue block16;
                    }
                    case "name": {
                        name2 = reader2.nextStringOrNull();
                        continue block16;
                    }
                    case "associated_event_id": {
                        associatedEventId = new SentryId.Deserializer().deserialize(reader2, logger);
                        continue block16;
                    }
                    case "replay_id": {
                        replayId = new SentryId.Deserializer().deserialize(reader2, logger);
                        continue block16;
                    }
                    case "url": {
                        url2 = reader2.nextStringOrNull();
                        continue block16;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            if (message2 == null) {
                String errorMessage = "Missing required field \"message\"";
                IllegalStateException exception = new IllegalStateException(errorMessage);
                logger.log(SentryLevel.ERROR, errorMessage, exception);
                throw exception;
            }
            Feedback feedback = new Feedback(message2);
            feedback.contactEmail = contactEmail;
            feedback.name = name2;
            feedback.associatedEventId = associatedEventId;
            feedback.replayId = replayId;
            feedback.url = url2;
            feedback.unknown = unknown;
            return feedback;
        }
    }
}

