/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkInfo
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String sdkName;
    @Nullable
    private Integer versionMajor;
    @Nullable
    private Integer versionMinor;
    @Nullable
    private Integer versionPatchlevel;
    @Nullable
    private Map<String, Object> unknown;

    @Nullable
    public String getSdkName() {
        return this.sdkName;
    }

    public void setSdkName(@Nullable String sdkName) {
        this.sdkName = sdkName;
    }

    @Nullable
    public Integer getVersionMajor() {
        return this.versionMajor;
    }

    public void setVersionMajor(@Nullable Integer versionMajor) {
        this.versionMajor = versionMajor;
    }

    @Nullable
    public Integer getVersionMinor() {
        return this.versionMinor;
    }

    public void setVersionMinor(@Nullable Integer versionMinor) {
        this.versionMinor = versionMinor;
    }

    @Nullable
    public Integer getVersionPatchlevel() {
        return this.versionPatchlevel;
    }

    public void setVersionPatchlevel(@Nullable Integer versionPatchlevel) {
        this.versionPatchlevel = versionPatchlevel;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.sdkName != null) {
            writer2.name("sdk_name").value(this.sdkName);
        }
        if (this.versionMajor != null) {
            writer2.name("version_major").value(this.versionMajor);
        }
        if (this.versionMinor != null) {
            writer2.name("version_minor").value(this.versionMinor);
        }
        if (this.versionPatchlevel != null) {
            writer2.name("version_patchlevel").value(this.versionPatchlevel);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String SDK_NAME = "sdk_name";
        public static final String VERSION_MAJOR = "version_major";
        public static final String VERSION_MINOR = "version_minor";
        public static final String VERSION_PATCHLEVEL = "version_patchlevel";
    }

    public static final class Deserializer
    implements JsonDeserializer<SdkInfo> {
        @Override
        @NotNull
        public SdkInfo deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            SdkInfo sdkInfo = new SdkInfo();
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block12: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "sdk_name": {
                        sdkInfo.sdkName = reader2.nextStringOrNull();
                        continue block12;
                    }
                    case "version_major": {
                        sdkInfo.versionMajor = reader2.nextIntegerOrNull();
                        continue block12;
                    }
                    case "version_minor": {
                        sdkInfo.versionMinor = reader2.nextIntegerOrNull();
                        continue block12;
                    }
                    case "version_patchlevel": {
                        sdkInfo.versionPatchlevel = reader2.nextIntegerOrNull();
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            sdkInfo.setUnknown(unknown);
            return sdkInfo;
        }
    }
}

