/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryIntegrationPackageStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryPackage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkVersion
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private String name;
    @NotNull
    private String version;
    @Nullable
    private Set<SentryPackage> deserializedPackages;
    @Nullable
    private Set<String> deserializedIntegrations;
    @Nullable
    private Map<String, Object> unknown;

    public SdkVersion(@NotNull String name2, @NotNull String version) {
        this.name = Objects.requireNonNull(name2, "name is required.");
        this.version = Objects.requireNonNull(version, "version is required.");
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull String version) {
        this.version = Objects.requireNonNull(version, "version is required.");
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name2) {
        this.name = Objects.requireNonNull(name2, "name is required.");
    }

    public void addPackage(@NotNull String name2, @NotNull String version) {
        SentryIntegrationPackageStorage.getInstance().addPackage(name2, version);
    }

    public void addIntegration(@NotNull String integration) {
        SentryIntegrationPackageStorage.getInstance().addIntegration(integration);
    }

    @NotNull
    public Set<SentryPackage> getPackageSet() {
        return this.deserializedPackages != null ? this.deserializedPackages : SentryIntegrationPackageStorage.getInstance().getPackages();
    }

    @NotNull
    public Set<String> getIntegrationSet() {
        return this.deserializedIntegrations != null ? this.deserializedIntegrations : SentryIntegrationPackageStorage.getInstance().getIntegrations();
    }

    @NotNull
    public static SdkVersion updateSdkVersion(@Nullable SdkVersion sdk, @NotNull String name2, @NotNull String version) {
        Objects.requireNonNull(name2, "name is required.");
        Objects.requireNonNull(version, "version is required.");
        if (sdk == null) {
            sdk = new SdkVersion(name2, version);
        } else {
            sdk.setName(name2);
            sdk.setVersion(version);
        }
        return sdk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkVersion that = (SdkVersion)o;
        return this.name.equals(that.name) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("name").value(this.name);
        writer2.name("version").value(this.version);
        Set<SentryPackage> packages = this.getPackageSet();
        Set<String> integrations2 = this.getIntegrationSet();
        if (!packages.isEmpty()) {
            writer2.name("packages").value(logger, packages);
        }
        if (!integrations2.isEmpty()) {
            writer2.name("integrations").value(logger, integrations2);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String NAME = "name";
        public static final String VERSION = "version";
        public static final String PACKAGES = "packages";
        public static final String INTEGRATIONS = "integrations";
    }

    public static final class Deserializer
    implements JsonDeserializer<SdkVersion> {
        @Override
        @NotNull
        public SdkVersion deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            IllegalStateException exception;
            String message2;
            String name2 = null;
            String version = null;
            ArrayList<SentryPackage> packages = new ArrayList<SentryPackage>();
            ArrayList integrations2 = new ArrayList();
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block12: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "name": {
                        name2 = reader2.nextString();
                        continue block12;
                    }
                    case "version": {
                        version = reader2.nextString();
                        continue block12;
                    }
                    case "packages": {
                        List<SentryPackage> deserializedPackages = reader2.nextListOrNull(logger, new SentryPackage.Deserializer());
                        if (deserializedPackages == null) continue block12;
                        packages.addAll(deserializedPackages);
                        continue block12;
                    }
                    case "integrations": {
                        List deserializedIntegrations = (List)reader2.nextObjectOrNull();
                        if (deserializedIntegrations == null) continue block12;
                        integrations2.addAll(deserializedIntegrations);
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            if (name2 == null) {
                message2 = "Missing required field \"name\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            if (version == null) {
                message2 = "Missing required field \"version\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            SdkVersion sdkVersion = new SdkVersion(name2, version);
            sdkVersion.deserializedPackages = new CopyOnWriteArraySet(packages);
            sdkVersion.deserializedIntegrations = new CopyOnWriteArraySet(integrations2);
            sdkVersion.setUnknown(unknown);
            return sdkVersion;
        }
    }
}

