/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryPackage
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private String name;
    @NotNull
    private String version;
    @Nullable
    private Map<String, Object> unknown;

    public SentryPackage(@NotNull String name2, @NotNull String version) {
        this.name = io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects.requireNonNull(name2, "name is required.");
        this.version = io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects.requireNonNull(version, "version is required.");
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name2) {
        this.name = io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects.requireNonNull(name2, "name is required.");
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull String version) {
        this.version = io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects.requireNonNull(version, "version is required.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryPackage that = (SentryPackage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("name").value(this.name);
        writer2.name("version").value(this.version);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String NAME = "name";
        public static final String VERSION = "version";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryPackage> {
        @Override
        @NotNull
        public SentryPackage deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            IllegalStateException exception;
            String message2;
            String name2 = null;
            String version = null;
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block8: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "name": {
                        name2 = reader2.nextString();
                        continue block8;
                    }
                    case "version": {
                        version = reader2.nextString();
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            if (name2 == null) {
                message2 = "Missing required field \"name\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            if (version == null) {
                message2 = "Missing required field \"version\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            SentryPackage sentryPackage = new SentryPackage(name2, version);
            sentryPackage.setUnknown(unknown);
            return sentryPackage;
        }
    }
}

