/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryStackFrame;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryStackTrace
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private List<SentryStackFrame> frames;
    @Nullable
    private Map<String, String> registers;
    @Nullable
    private Boolean snapshot;
    @Nullable
    private Map<String, Object> unknown;

    public SentryStackTrace() {
    }

    public SentryStackTrace(@Nullable List<SentryStackFrame> frames) {
        this.frames = frames;
    }

    @Nullable
    public List<SentryStackFrame> getFrames() {
        return this.frames;
    }

    public void setFrames(@Nullable List<SentryStackFrame> frames) {
        this.frames = frames;
    }

    @Nullable
    public Map<String, String> getRegisters() {
        return this.registers;
    }

    public void setRegisters(@Nullable Map<String, String> registers) {
        this.registers = registers;
    }

    @Nullable
    public Boolean getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(@Nullable Boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.frames != null) {
            writer2.name("frames").value(logger, this.frames);
        }
        if (this.registers != null) {
            writer2.name("registers").value(logger, this.registers);
        }
        if (this.snapshot != null) {
            writer2.name("snapshot").value(this.snapshot);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String FRAMES = "frames";
        public static final String REGISTERS = "registers";
        public static final String SNAPSHOT = "snapshot";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryStackTrace> {
        @Override
        @NotNull
        public SentryStackTrace deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            SentryStackTrace sentryStackTrace = new SentryStackTrace();
            ConcurrentHashMap<String, Object> unknown = null;
            reader2.beginObject();
            block10: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "frames": {
                        sentryStackTrace.frames = reader2.nextListOrNull(logger, new SentryStackFrame.Deserializer());
                        continue block10;
                    }
                    case "registers": {
                        sentryStackTrace.registers = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        continue block10;
                    }
                    case "snapshot": {
                        sentryStackTrace.snapshot = reader2.nextBooleanOrNull();
                        continue block10;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            sentryStackTrace.setUnknown(unknown);
            reader2.endObject();
            return sentryStackTrace;
        }
    }
}

