/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEventType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RRWebBreadcrumbEvent
extends RRWebEvent
implements JsonUnknown,
JsonSerializable {
    public static final String EVENT_TAG = "breadcrumb";
    @NotNull
    private String tag = "breadcrumb";
    private double breadcrumbTimestamp;
    @Nullable
    private String breadcrumbType;
    @Nullable
    private String category;
    @Nullable
    private String message;
    @Nullable
    private SentryLevel level;
    @Nullable
    private Map<String, Object> data;
    @Nullable
    private Map<String, Object> unknown;
    @Nullable
    private Map<String, Object> payloadUnknown;
    @Nullable
    private Map<String, Object> dataUnknown;

    public RRWebBreadcrumbEvent() {
        super(RRWebEventType.Custom);
    }

    @NotNull
    public String getTag() {
        return this.tag;
    }

    public void setTag(@NotNull String tag2) {
        this.tag = tag2;
    }

    public double getBreadcrumbTimestamp() {
        return this.breadcrumbTimestamp;
    }

    public void setBreadcrumbTimestamp(double breadcrumbTimestamp) {
        this.breadcrumbTimestamp = breadcrumbTimestamp;
    }

    @Nullable
    public String getBreadcrumbType() {
        return this.breadcrumbType;
    }

    public void setBreadcrumbType(@Nullable String breadcrumbType) {
        this.breadcrumbType = breadcrumbType;
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message2) {
        this.message = message2;
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(@Nullable Map<String, Object> data2) {
        this.data = data2 == null ? null : new ConcurrentHashMap<String, Object>(data2);
    }

    @Nullable
    public Map<String, Object> getPayloadUnknown() {
        return this.payloadUnknown;
    }

    public void setPayloadUnknown(@Nullable Map<String, Object> payloadUnknown) {
        this.payloadUnknown = payloadUnknown;
    }

    @Nullable
    public Map<String, Object> getDataUnknown() {
        return this.dataUnknown;
    }

    public void setDataUnknown(@Nullable Map<String, Object> dataUnknown) {
        this.dataUnknown = dataUnknown;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        new RRWebEvent.Serializer().serialize(this, writer2, logger);
        writer2.name("data");
        this.serializeData(writer2, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    private void serializeData(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("tag").value(this.tag);
        writer2.name("payload");
        this.serializePayload(writer2, logger);
        if (this.dataUnknown != null) {
            for (String key : this.dataUnknown.keySet()) {
                Object value2 = this.dataUnknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    private void serializePayload(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.breadcrumbType != null) {
            writer2.name("type").value(this.breadcrumbType);
        }
        writer2.name("timestamp").value(logger, BigDecimal.valueOf(this.breadcrumbTimestamp));
        if (this.category != null) {
            writer2.name("category").value(this.category);
        }
        if (this.message != null) {
            writer2.name("message").value(this.message);
        }
        if (this.level != null) {
            writer2.name("level").value(logger, this.level);
        }
        if (this.data != null) {
            writer2.name("data").value(logger, this.data);
        }
        if (this.payloadUnknown != null) {
            for (String key : this.payloadUnknown.keySet()) {
                Object value2 = this.payloadUnknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String DATA = "data";
        public static final String PAYLOAD = "payload";
        public static final String TIMESTAMP = "timestamp";
        public static final String TYPE = "type";
        public static final String CATEGORY = "category";
        public static final String MESSAGE = "message";
        public static final String LEVEL = "level";
    }

    public static final class Deserializer
    implements JsonDeserializer<RRWebBreadcrumbEvent> {
        @Override
        @NotNull
        public RRWebBreadcrumbEvent deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            @Nullable HashMap<String, Object> unknown = null;
            RRWebBreadcrumbEvent event2 = new RRWebBreadcrumbEvent();
            RRWebEvent.Deserializer baseEventDeserializer = new RRWebEvent.Deserializer();
            block6: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "data": {
                        this.deserializeData(event2, reader2, logger);
                        continue block6;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event2, nextName, reader2, logger)) continue;
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            event2.setUnknown(unknown);
            reader2.endObject();
            return event2;
        }

        private void deserializeData(@NotNull RRWebBreadcrumbEvent event2, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            ConcurrentHashMap<String, Object> dataUnknown = null;
            reader2.beginObject();
            block8: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "tag": {
                        String tag2 = reader2.nextStringOrNull();
                        event2.tag = tag2 == null ? "" : tag2;
                        continue block8;
                    }
                    case "payload": {
                        this.deserializePayload(event2, reader2, logger);
                        continue block8;
                    }
                }
                if (dataUnknown == null) {
                    dataUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, dataUnknown, nextName);
            }
            event2.setDataUnknown(dataUnknown);
            reader2.endObject();
        }

        private void deserializePayload(@NotNull RRWebBreadcrumbEvent event2, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            ConcurrentHashMap<String, Object> payloadUnknown = null;
            reader2.beginObject();
            block18: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "type": {
                        event2.breadcrumbType = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "timestamp": {
                        event2.breadcrumbTimestamp = reader2.nextDouble();
                        continue block18;
                    }
                    case "category": {
                        event2.category = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "message": {
                        event2.message = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "level": {
                        try {
                            event2.level = new SentryLevel.Deserializer().deserialize(reader2, logger);
                        }
                        catch (Exception exception) {
                            logger.log(SentryLevel.DEBUG, exception, "Error when deserializing SentryLevel", new Object[0]);
                        }
                        continue block18;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        if (deserializedData == null) continue block18;
                        event2.data = deserializedData;
                        continue block18;
                    }
                }
                if (payloadUnknown == null) {
                    payloadUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, payloadUnknown, nextName);
            }
            event2.setPayloadUnknown(payloadUnknown);
            reader2.endObject();
        }
    }
}

