/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEventType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class RRWebEvent {
    @NotNull
    private RRWebEventType type;
    private long timestamp;

    protected RRWebEvent(@NotNull RRWebEventType type) {
        this.type = type;
        this.timestamp = System.currentTimeMillis();
    }

    protected RRWebEvent() {
        this(RRWebEventType.Custom);
    }

    @NotNull
    public RRWebEventType getType() {
        return this.type;
    }

    public void setType(@NotNull RRWebEventType type) {
        this.type = type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp2) {
        this.timestamp = timestamp2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RRWebEvent)) {
            return false;
        }
        RRWebEvent that = (RRWebEvent)o;
        return this.timestamp == that.timestamp && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.timestamp);
    }

    public static final class Deserializer {
        public boolean deserializeValue(@NotNull RRWebEvent baseEvent, @NotNull String nextName, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            switch (nextName) {
                case "type": {
                    baseEvent.type = Objects.requireNonNull(reader2.nextOrNull(logger, new RRWebEventType.Deserializer()), "");
                    return true;
                }
                case "timestamp": {
                    baseEvent.timestamp = reader2.nextLong();
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Serializer {
        public void serialize(@NotNull RRWebEvent baseEvent, @NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
            writer2.name("type").value(logger, baseEvent.type);
            writer2.name("timestamp").value(baseEvent.timestamp);
        }
    }

    public static final class JsonKeys {
        public static final String TYPE = "type";
        public static final String TIMESTAMP = "timestamp";
        public static final String TAG = "tag";
    }
}

