/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEventType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RRWebSpanEvent
extends RRWebEvent
implements JsonSerializable,
JsonUnknown {
    public static final String EVENT_TAG = "performanceSpan";
    @NotNull
    private String tag = "performanceSpan";
    @Nullable
    private String op;
    @Nullable
    private String description;
    private double startTimestamp;
    private double endTimestamp;
    @Nullable
    private Map<String, Object> data;
    @Nullable
    private Map<String, Object> unknown;
    @Nullable
    private Map<String, Object> payloadUnknown;
    @Nullable
    private Map<String, Object> dataUnknown;

    public RRWebSpanEvent() {
        super(RRWebEventType.Custom);
    }

    @NotNull
    public String getTag() {
        return this.tag;
    }

    public void setTag(@NotNull String tag2) {
        this.tag = tag2;
    }

    @Nullable
    public String getOp() {
        return this.op;
    }

    public void setOp(@Nullable String op) {
        this.op = op;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description2) {
        this.description = description2;
    }

    public double getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(double startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public double getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(double endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(@Nullable Map<String, Object> data2) {
        this.data = data2 == null ? null : new ConcurrentHashMap<String, Object>(data2);
    }

    @Nullable
    public Map<String, Object> getPayloadUnknown() {
        return this.payloadUnknown;
    }

    public void setPayloadUnknown(@Nullable Map<String, Object> payloadUnknown) {
        this.payloadUnknown = payloadUnknown;
    }

    @Nullable
    public Map<String, Object> getDataUnknown() {
        return this.dataUnknown;
    }

    public void setDataUnknown(@Nullable Map<String, Object> dataUnknown) {
        this.dataUnknown = dataUnknown;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        new RRWebEvent.Serializer().serialize(this, writer2, logger);
        writer2.name("data");
        this.serializeData(writer2, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    private void serializeData(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("tag").value(this.tag);
        writer2.name("payload");
        this.serializePayload(writer2, logger);
        if (this.dataUnknown != null) {
            for (String key : this.dataUnknown.keySet()) {
                Object value2 = this.dataUnknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    private void serializePayload(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.op != null) {
            writer2.name("op").value(this.op);
        }
        if (this.description != null) {
            writer2.name("description").value(this.description);
        }
        writer2.name("startTimestamp").value(logger, BigDecimal.valueOf(this.startTimestamp));
        writer2.name("endTimestamp").value(logger, BigDecimal.valueOf(this.endTimestamp));
        if (this.data != null) {
            writer2.name("data").value(logger, this.data);
        }
        if (this.payloadUnknown != null) {
            for (String key : this.payloadUnknown.keySet()) {
                Object value2 = this.payloadUnknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String DATA = "data";
        public static final String PAYLOAD = "payload";
        public static final String OP = "op";
        public static final String DESCRIPTION = "description";
        public static final String START_TIMESTAMP = "startTimestamp";
        public static final String END_TIMESTAMP = "endTimestamp";
    }

    public static final class Deserializer
    implements JsonDeserializer<RRWebSpanEvent> {
        @Override
        @NotNull
        public RRWebSpanEvent deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            @Nullable HashMap<String, Object> unknown = null;
            RRWebSpanEvent event2 = new RRWebSpanEvent();
            RRWebEvent.Deserializer baseEventDeserializer = new RRWebEvent.Deserializer();
            block6: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "data": {
                        this.deserializeData(event2, reader2, logger);
                        continue block6;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event2, nextName, reader2, logger)) continue;
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            event2.setUnknown(unknown);
            reader2.endObject();
            return event2;
        }

        private void deserializeData(@NotNull RRWebSpanEvent event2, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            ConcurrentHashMap<String, Object> dataUnknown = null;
            reader2.beginObject();
            block8: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "tag": {
                        String tag2 = reader2.nextStringOrNull();
                        event2.tag = tag2 == null ? "" : tag2;
                        continue block8;
                    }
                    case "payload": {
                        this.deserializePayload(event2, reader2, logger);
                        continue block8;
                    }
                }
                if (dataUnknown == null) {
                    dataUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, dataUnknown, nextName);
            }
            event2.setDataUnknown(dataUnknown);
            reader2.endObject();
        }

        private void deserializePayload(@NotNull RRWebSpanEvent event2, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            ConcurrentHashMap<String, Object> payloadUnknown = null;
            reader2.beginObject();
            block14: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "op": {
                        event2.op = reader2.nextStringOrNull();
                        continue block14;
                    }
                    case "description": {
                        event2.description = reader2.nextStringOrNull();
                        continue block14;
                    }
                    case "startTimestamp": {
                        event2.startTimestamp = reader2.nextDouble();
                        continue block14;
                    }
                    case "endTimestamp": {
                        event2.endTimestamp = reader2.nextDouble();
                        continue block14;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        if (deserializedData == null) continue block14;
                        event2.data = deserializedData;
                        continue block14;
                    }
                }
                if (payloadUnknown == null) {
                    payloadUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, payloadUnknown, nextName);
            }
            event2.setPayloadUnknown(payloadUnknown);
            reader2.endObject();
        }
    }
}

