/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.transport;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProxyAuthenticator
extends Authenticator {
    @NotNull
    private final String user;
    @NotNull
    private final String password;

    ProxyAuthenticator(@NotNull String user2, @NotNull String password) {
        this.user = Objects.requireNonNull(user2, "user is required");
        this.password = Objects.requireNonNull(password, "password is required");
    }

    @Override
    @Nullable
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
        return null;
    }

    @NotNull
    String getUser() {
        return this.user;
    }

    @NotNull
    String getPassword() {
        return this.password;
    }
}

