/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadClass {
    @Nullable
    public Class<?> loadClass(@NotNull String clazz, @Nullable ILogger logger) {
        block6: {
            try {
                return Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                if (logger != null) {
                    logger.log(SentryLevel.INFO, "Class not available: " + clazz, new Object[0]);
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (logger != null) {
                    logger.log(SentryLevel.ERROR, "Failed to load (UnsatisfiedLinkError) " + clazz, e);
                }
            }
            catch (Throwable e) {
                if (logger == null) break block6;
                logger.log(SentryLevel.ERROR, "Failed to initialize " + clazz, e);
            }
        }
        return null;
    }

    public boolean isClassAvailable(@NotNull String clazz, @Nullable ILogger logger) {
        return this.loadClass(clazz, logger) != null;
    }

    public boolean isClassAvailable(@NotNull String clazz, @Nullable SentryOptions options2) {
        return this.isClassAvailable(clazz, options2 != null ? options2.getLogger() : null);
    }
}

