/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Random
implements Serializable {
    private static final long serialVersionUID = 3905348978240129619L;
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    static final String BadBound = "bound must be positive";
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);

    public Random() {
        this(Random.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 1181783497276652981L)) {
        }
        return next;
    }

    public Random(long seed) {
        if (this.getClass() == Random.class) {
            this.seed = new AtomicLong(Random.initialScramble(seed));
        } else {
            this.seed = new AtomicLong();
            this.setSeed(seed);
        }
    }

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long seed) {
        this.seed.set(Random.initialScramble(seed));
    }

    private int next(int bits) {
        long nextseed;
        long oldseed;
        AtomicLong seed = this.seed;
        while (!seed.compareAndSet(oldseed = seed.get(), nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(nextseed >>> 48 - bits);
    }

    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int rnd = this.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    final long internalNextLong(long origin, long bound) {
        long r = this.nextLong();
        if (origin < bound) {
            long n = bound - origin;
            long m = n - 1L;
            if ((n & m) == 0L) {
                r = (r & m) + origin;
            } else if (n > 0L) {
                long u = r >>> 1;
                while (u + m - (r = u % n) < 0L) {
                    u = this.nextLong() >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = this.nextLong();
                }
            }
        }
        return r;
    }

    final int internalNextInt(int origin, int bound) {
        if (origin < bound) {
            int r;
            int n = bound - origin;
            if (n > 0) {
                return this.nextInt(n) + origin;
            }
            while ((r = this.nextInt()) < origin || r >= bound) {
            }
            return r;
        }
        return this.nextInt();
    }

    final double internalNextDouble(double origin, double bound) {
        double r = this.nextDouble();
        if (origin < bound && (r = r * (bound - origin) + origin) >= bound) {
            r = Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
        }
        return r;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int r = this.next(31);
        int m = bound - 1;
        if ((bound & m) == 0) {
            r = (int)((long)bound * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % bound) + m < 0) {
                u = this.next(31);
            }
        }
        return r;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }
}

