/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Request;
import java.net.URI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class UrlUtils {
    @NotNull
    public static final String SENSITIVE_DATA_SUBSTITUTE = "[Filtered]";

    @Nullable
    public static UrlDetails parseNullable(@Nullable String url2) {
        return url2 == null ? null : UrlUtils.parse(url2);
    }

    @NotNull
    public static UrlDetails parse(@NotNull String url2) {
        try {
            URI uri = new URI(url2);
            if (uri.isAbsolute() && !UrlUtils.isValidAbsoluteUrl(uri)) {
                return new UrlDetails(null, null, null);
            }
            @NotNull String schemeAndSeparator = uri.getScheme() == null ? "" : uri.getScheme() + "://";
            @NotNull String authority = uri.getRawAuthority() == null ? "" : uri.getRawAuthority();
            @NotNull String path = uri.getRawPath() == null ? "" : uri.getRawPath();
            @Nullable String query2 = uri.getRawQuery();
            @Nullable String fragment = uri.getRawFragment();
            @NotNull String filteredUrl = schemeAndSeparator + UrlUtils.filterUserInfo(authority) + path;
            return new UrlDetails(filteredUrl, query2, fragment);
        }
        catch (Exception e) {
            return new UrlDetails(null, null, null);
        }
    }

    private static boolean isValidAbsoluteUrl(@NotNull URI uri) {
        try {
            uri.toURL();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @NotNull
    private static String filterUserInfo(@NotNull String url2) {
        if (!url2.contains("@")) {
            return url2;
        }
        if (url2.startsWith("@")) {
            return SENSITIVE_DATA_SUBSTITUTE + url2;
        }
        @NotNull String userInfo = url2.substring(0, url2.indexOf(64));
        @NotNull String filteredUserInfo = userInfo.contains(":") ? "[Filtered]:[Filtered]" : SENSITIVE_DATA_SUBSTITUTE;
        return filteredUserInfo + url2.substring(url2.indexOf(64));
    }

    public static final class UrlDetails {
        @Nullable
        private final String url;
        @Nullable
        private final String query;
        @Nullable
        private final String fragment;

        public UrlDetails(@Nullable String url2, @Nullable String query2, @Nullable String fragment) {
            this.url = url2;
            this.query = query2;
            this.fragment = fragment;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }

        @NotNull
        public String getUrlOrFallback() {
            if (this.url == null) {
                return "unknown";
            }
            return this.url;
        }

        @Nullable
        public String getQuery() {
            return this.query;
        }

        @Nullable
        public String getFragment() {
            return this.fragment;
        }

        public void applyToRequest(@Nullable Request request) {
            if (request == null) {
                return;
            }
            request.setUrl(this.url);
            request.setQueryString(this.query);
            request.setFragment(this.fragment);
        }

        public void applyToSpan(@Nullable ISpan span) {
            if (span == null) {
                return;
            }
            if (this.query != null) {
                span.setData("http.query", this.query);
            }
            if (this.fragment != null) {
                span.setData("http.fragment", this.fragment);
            }
        }
    }
}

