/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.javassist;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.CannotCompileException;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.ClassClassPath;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.ClassPath;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.ClassPathList;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.DirClassPath;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.JarClassPath;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.JarDirClassPath;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.LoaderClassPath;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.NotFoundException;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ClassFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

final class ClassPoolTail {
    protected ClassPathList pathList = null;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[class path: ");
        ClassPathList list2 = this.pathList;
        while (list2 != null) {
            buf.append(list2.path.toString());
            buf.append(File.pathSeparatorChar);
            list2 = list2.next;
        }
        buf.append(']');
        return buf.toString();
    }

    public synchronized ClassPath insertClassPath(ClassPath cp) {
        this.pathList = new ClassPathList(cp, this.pathList);
        return cp;
    }

    public synchronized ClassPath appendClassPath(ClassPath cp) {
        ClassPathList tail = new ClassPathList(cp, null);
        ClassPathList list2 = this.pathList;
        if (list2 == null) {
            this.pathList = tail;
        } else {
            while (list2.next != null) {
                list2 = list2.next;
            }
            list2.next = tail;
        }
        return cp;
    }

    public synchronized void removeClassPath(ClassPath cp) {
        ClassPathList list2 = this.pathList;
        if (list2 != null) {
            if (list2.path == cp) {
                this.pathList = list2.next;
            } else {
                while (list2.next != null) {
                    if (list2.next.path == cp) {
                        list2.next = list2.next.next;
                        continue;
                    }
                    list2 = list2.next;
                }
            }
        }
    }

    public ClassPath appendSystemPath() {
        if (ClassFile.MAJOR_VERSION < 53) {
            return this.appendClassPath(new ClassClassPath());
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.appendClassPath(new LoaderClassPath(cl));
    }

    public ClassPath insertClassPath(String pathname) throws NotFoundException {
        return this.insertClassPath(ClassPoolTail.makePathObject(pathname));
    }

    public ClassPath appendClassPath(String pathname) throws NotFoundException {
        return this.appendClassPath(ClassPoolTail.makePathObject(pathname));
    }

    private static ClassPath makePathObject(String pathname) throws NotFoundException {
        String lower = pathname.toLowerCase();
        if (lower.endsWith(".jar") || lower.endsWith(".zip")) {
            return new JarClassPath(pathname);
        }
        int len = pathname.length();
        if (len > 2 && pathname.charAt(len - 1) == '*' && (pathname.charAt(len - 2) == '/' || pathname.charAt(len - 2) == File.separatorChar)) {
            String dir = pathname.substring(0, len - 2);
            return new JarDirClassPath(dir);
        }
        return new DirClassPath(pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClassfile(String classname, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        InputStream fin = this.openClassfile(classname);
        if (fin == null) {
            throw new NotFoundException(classname);
        }
        try {
            ClassPoolTail.copyStream(fin, out);
        }
        finally {
            fin.close();
        }
    }

    InputStream openClassfile(String classname) throws NotFoundException {
        ClassPathList list2 = this.pathList;
        InputStream ins = null;
        NotFoundException error = null;
        while (list2 != null) {
            block5: {
                try {
                    ins = list2.path.openClassfile(classname);
                }
                catch (NotFoundException e) {
                    if (error != null) break block5;
                    error = e;
                }
            }
            if (ins == null) {
                list2 = list2.next;
                continue;
            }
            return ins;
        }
        if (error != null) {
            throw error;
        }
        return null;
    }

    public URL find(String classname) {
        ClassPathList list2 = this.pathList;
        URL url2 = null;
        while (list2 != null) {
            url2 = list2.path.find(classname);
            if (url2 == null) {
                list2 = list2.next;
                continue;
            }
            return url2;
        }
        return null;
    }

    public static byte[] readStream(InputStream fin) throws IOException {
        byte[][] bufs = new byte[8][];
        int bufsize = 4096;
        for (int i = 0; i < 8; ++i) {
            bufs[i] = new byte[bufsize];
            int size = 0;
            int len = 0;
            do {
                if ((len = fin.read(bufs[i], size, bufsize - size)) >= 0) continue;
                byte[] result2 = new byte[bufsize - 4096 + size];
                int s = 0;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(bufs[j], 0, result2, s, s + 4096);
                    s = s + s + 4096;
                }
                System.arraycopy(bufs[i], 0, result2, s, size);
                return result2;
            } while ((size += len) < bufsize);
            bufsize *= 2;
        }
        throw new IOException("too much data");
    }

    public static void copyStream(InputStream fin, OutputStream fout) throws IOException {
        int bufsize = 4096;
        byte[] buf = null;
        for (int i = 0; i < 64; ++i) {
            if (i < 8) {
                buf = new byte[bufsize *= 2];
            }
            int size = 0;
            int len = 0;
            do {
                if ((len = fin.read(buf, size, bufsize - size)) >= 0) continue;
                fout.write(buf, 0, size);
                return;
            } while ((size += len) < bufsize);
            fout.write(buf);
        }
        throw new IOException("too much data");
    }
}

