/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.ClassPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ConstPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.Descriptor;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.AnnotationsWriter;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.MemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class EnumMemberValue
extends MemberValue {
    int typeIndex;
    int valueIndex;

    public EnumMemberValue(int type, int value2, ConstPool cp) {
        super('e', cp);
        this.typeIndex = type;
        this.valueIndex = value2;
    }

    public EnumMemberValue(ConstPool cp) {
        super('e', cp);
        this.valueIndex = 0;
        this.typeIndex = 0;
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) throws ClassNotFoundException {
        try {
            return this.getType(cl).getField(this.getValue()).get(null);
        }
        catch (NoSuchFieldException e) {
            throw new ClassNotFoundException(this.getType() + "." + this.getValue());
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException(this.getType() + "." + this.getValue());
        }
    }

    @Override
    Class<?> getType(ClassLoader cl) throws ClassNotFoundException {
        return EnumMemberValue.loadClass(cl, this.getType());
    }

    public String getType() {
        return Descriptor.toClassName(this.cp.getUtf8Info(this.typeIndex));
    }

    public void setType(String typename) {
        this.typeIndex = this.cp.addUtf8Info(Descriptor.of(typename));
    }

    public String getValue() {
        return this.cp.getUtf8Info(this.valueIndex);
    }

    public void setValue(String name2) {
        this.valueIndex = this.cp.addUtf8Info(name2);
    }

    public String toString() {
        return this.getType() + "." + this.getValue();
    }

    @Override
    public void write(AnnotationsWriter writer2) throws IOException {
        writer2.enumConstValue(this.cp.getUtf8Info(this.typeIndex), this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitEnumMemberValue(this);
    }
}

