/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.ClassPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ConstPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.AnnotationsWriter;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.MemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class IntegerMemberValue
extends MemberValue {
    int valueIndex;

    public IntegerMemberValue(int index, ConstPool cp) {
        super('I', cp);
        this.valueIndex = index;
    }

    public IntegerMemberValue(ConstPool cp, int value2) {
        super('I', cp);
        this.setValue(value2);
    }

    public IntegerMemberValue(ConstPool cp) {
        super('I', cp);
        this.setValue(0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return this.getValue();
    }

    @Override
    Class<?> getType(ClassLoader cl) {
        return Integer.TYPE;
    }

    public int getValue() {
        return this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(int newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer2) throws IOException {
        writer2.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitIntegerMemberValue(this);
    }
}

