/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime;

import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimeArithmeticException;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimePeriod;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimePeriodKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimeUnit;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.InstantJvmKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.InstantKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.TimeZone;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.DivRemResult;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.MathJvmKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.MathKt;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import kotlin.time.jdk8.InstantConversionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=5, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001b\u0010\u0006\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a!\u0010\n\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a#\u0010\n\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\n\u0010\u000e\u001a)\u0010\n\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u0011\u001a)\u0010\u0012\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0011\u001a)\u0010\n\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u0014\u001a!\u0010\n\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0015\u00a2\u0006\u0004\b\n\u0010\u0016\u001a!\u0010\u0018\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a)\u0010\u001a\u001a\u00020\u0013*\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lkotlin/time/Instant;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;", "zone", "Ljava/time/ZonedDateTime;", "atZone$InstantJvmKt__InstantKt", "(Lkotlin/time/Instant;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;)Ljava/time/ZonedDateTime;", "atZone", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimePeriod;", "period", "timeZone", "plus", "(Lkotlin/time/Instant;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimePeriod;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;)Lkotlin/time/Instant;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit;", "unit", "(Lkotlin/time/Instant;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;)Lkotlin/time/Instant;", "", "value", "(Lkotlin/time/Instant;ILio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;)Lkotlin/time/Instant;", "minus", "", "(Lkotlin/time/Instant;JLio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;)Lkotlin/time/Instant;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$TimeBased;", "(Lkotlin/time/Instant;JLio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$TimeBased;)Lkotlin/time/Instant;", "other", "periodUntil", "(Lkotlin/time/Instant;Lkotlin/time/Instant;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimePeriod;", "until", "(Lkotlin/time/Instant;Lkotlin/time/Instant;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;)J", "kotlinx-datetime"}, xs="io/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/InstantJvmKt")
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlinx/datetime/InstantJvmKt__InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
final class InstantJvmKt__InstantKt {
    private static final ZonedDateTime atZone$InstantJvmKt__InstantKt(kotlin.time.Instant $this$atZone, TimeZone zone) {
        ZonedDateTime zonedDateTime;
        try {
            zonedDateTime = InstantConversionsJDK8Kt.toJavaInstant((kotlin.time.Instant)$this$atZone).atZone(zone.getZoneId$kotlinx_datetime());
            Intrinsics.checkNotNull((Object)zonedDateTime);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
        return zonedDateTime;
    }

    @NotNull
    public static final kotlin.time.Instant plus(@NotNull kotlin.time.Instant $this$plus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        try {
            ZonedDateTime thisZdt = InstantJvmKt__InstantKt.atZone$InstantJvmKt__InstantKt($this$plus, timeZone);
            DateTimePeriod $this$plus_u24lambda_u243 = period;
            boolean bl = false;
            ZonedDateTime $this$plus_u24lambda_u243_u24lambda_u240 = thisZdt;
            boolean bl2 = false;
            ZonedDateTime $this$plus_u24lambda_u243_u24lambda_u241 = $this$plus_u24lambda_u243.getTotalMonths$kotlinx_datetime() != 0L ? $this$plus_u24lambda_u243_u24lambda_u240.plusMonths($this$plus_u24lambda_u243.getTotalMonths$kotlinx_datetime()) : $this$plus_u24lambda_u243_u24lambda_u240;
            boolean bl3 = false;
            ZonedDateTime $this$plus_u24lambda_u243_u24lambda_u242 = $this$plus_u24lambda_u243.getDays() != 0 ? $this$plus_u24lambda_u243_u24lambda_u241.plusDays($this$plus_u24lambda_u243.getDays()) : $this$plus_u24lambda_u243_u24lambda_u241;
            boolean bl4 = false;
            Instant instant = ($this$plus_u24lambda_u243.getTotalNanoseconds$kotlinx_datetime() != 0L ? $this$plus_u24lambda_u243_u24lambda_u242.plusNanos($this$plus_u24lambda_u243.getTotalNanoseconds$kotlinx_datetime()) : $this$plus_u24lambda_u243_u24lambda_u242).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            return InstantConversionsJDK8Kt.toKotlinInstant((Instant)instant);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
    }

    @Deprecated(message="Use the plus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.plus(1, unit, timeZone)", imports={}))
    @NotNull
    public static final kotlin.time.Instant plus(@NotNull kotlin.time.Instant $this$plus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.plus($this$plus, 1L, unit, timeZone);
    }

    @NotNull
    public static final kotlin.time.Instant plus(@NotNull kotlin.time.Instant $this$plus, int value2, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.plus($this$plus, (long)value2, unit, timeZone);
    }

    @NotNull
    public static final kotlin.time.Instant minus(@NotNull kotlin.time.Instant $this$minus, int value2, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.plus($this$minus, -((long)value2), unit, timeZone);
    }

    @NotNull
    public static final kotlin.time.Instant plus(@NotNull kotlin.time.Instant $this$plus, long value2, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        kotlin.time.Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        try {
            Instant instant2;
            ZonedDateTime thisZdt = InstantJvmKt__InstantKt.atZone$InstantJvmKt__InstantKt($this$plus, timeZone);
            DateTimeUnit dateTimeUnit = unit;
            if (dateTimeUnit instanceof DateTimeUnit.TimeBased) {
                Instant instant3;
                Instant it = instant3 = InstantConversionsJDK8Kt.toJavaInstant((kotlin.time.Instant)InstantJvmKt.plus($this$plus, value2, (DateTimeUnit.TimeBased)unit));
                boolean bl = false;
                it.atZone(timeZone.getZoneId$kotlinx_datetime());
                instant2 = instant3;
            } else if (dateTimeUnit instanceof DateTimeUnit.DayBased) {
                instant2 = thisZdt.plusDays(MathJvmKt.safeMultiply(value2, (long)((DateTimeUnit.DayBased)unit).getDays())).toInstant();
            } else if (dateTimeUnit instanceof DateTimeUnit.MonthBased) {
                instant2 = thisZdt.plusMonths(MathJvmKt.safeMultiply(value2, (long)((DateTimeUnit.MonthBased)unit).getMonths())).toInstant();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Instant instant4 = instant2;
            Intrinsics.checkNotNull((Object)instant4);
            instant = InstantConversionsJDK8Kt.toKotlinInstant((Instant)instant4);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            throw new DateTimeArithmeticException("Instant " + $this$plus + " cannot be represented as local date when adding " + value2 + ' ' + unit + " to it", e);
        }
        return instant;
    }

    @NotNull
    public static final kotlin.time.Instant plus(@NotNull kotlin.time.Instant $this$plus, long value2, @NotNull DateTimeUnit.TimeBased unit) {
        kotlin.time.Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        try {
            DivRemResult divRemResult = MathKt.multiplyAndDivide(value2, unit.getNanoseconds(), 1000000000L);
            boolean bl = false;
            long d = divRemResult.component1();
            long r = divRemResult.component2();
            instant = $this$plus.plus-LRDsOJo(DurationKt.toDuration((long)d, (DurationUnit)DurationUnit.SECONDS)).plus-LRDsOJo(DurationKt.toDuration((long)r, (DurationUnit)DurationUnit.NANOSECONDS));
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            instant = Instant.Companion.fromEpochSeconds$default((Instant.Companion)kotlin.time.Instant.Companion, (long)(value2 > 0L ? Long.MAX_VALUE : Long.MIN_VALUE), (long)0L, (int)2, null);
        }
        return instant;
    }

    @NotNull
    public static final DateTimePeriod periodUntil(@NotNull kotlin.time.Instant $this$periodUntil, @NotNull kotlin.time.Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$periodUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        ZonedDateTime thisZdt = InstantJvmKt__InstantKt.atZone$InstantJvmKt__InstantKt($this$periodUntil, timeZone);
        ZonedDateTime otherZdt = InstantJvmKt__InstantKt.atZone$InstantJvmKt__InstantKt(other, timeZone);
        long months = thisZdt.until(otherZdt, ChronoUnit.MONTHS);
        ZonedDateTime zonedDateTime = thisZdt.plusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"plusMonths(...)");
        thisZdt = zonedDateTime;
        long days = thisZdt.until(otherZdt, ChronoUnit.DAYS);
        ZonedDateTime zonedDateTime2 = thisZdt.plusDays(days);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"plusDays(...)");
        thisZdt = zonedDateTime2;
        long nanoseconds = thisZdt.until(otherZdt, ChronoUnit.NANOS);
        return DateTimePeriodKt.buildDateTimePeriod(months, (int)days, nanoseconds);
    }

    public static final long until(@NotNull kotlin.time.Instant $this$until, @NotNull kotlin.time.Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        try {
            long l2;
            ZonedDateTime thisZdt = InstantJvmKt__InstantKt.atZone$InstantJvmKt__InstantKt($this$until, timeZone);
            ZonedDateTime otherZdt = InstantJvmKt__InstantKt.atZone$InstantJvmKt__InstantKt(other, timeZone);
            DateTimeUnit dateTimeUnit = unit;
            if (dateTimeUnit instanceof DateTimeUnit.TimeBased) {
                l2 = InstantKt.until($this$until, other, (DateTimeUnit.TimeBased)unit);
            } else if (dateTimeUnit instanceof DateTimeUnit.DayBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.DAYS) / (long)((DateTimeUnit.DayBased)unit).getDays();
            } else if (dateTimeUnit instanceof DateTimeUnit.MonthBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.MONTHS) / (long)((DateTimeUnit.MonthBased)unit).getMonths();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            l = l2;
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
        catch (ArithmeticException e) {
            l = $this$until.compareTo(other) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }
}

