/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime;

import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.LocalDate;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.LocalDateTime;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.LocalTime;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.UtcOffset;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.UtcOffsetJvmKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.YearMonth;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.YearMonthJvmKt;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/Ser;", "Ljava/io/Externalizable;", "", "typeTag", "", "value", "<init>", "(ILjava/lang/Object;)V", "()V", "Ljava/io/ObjectOutput;", "out", "", "writeExternal", "(Ljava/io/ObjectOutput;)V", "Ljava/io/ObjectInput;", "in", "readExternal", "(Ljava/io/ObjectInput;)V", "readResolve", "()Ljava/lang/Object;", "I", "Ljava/lang/Object;", "Companion", "kotlinx-datetime"})
@PublishedApi
public final class Ser
implements Externalizable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int typeTag;
    @Nullable
    private Object value;
    private static final long serialVersionUID = 0L;
    public static final int DATE_TAG = 2;
    public static final int TIME_TAG = 3;
    public static final int DATE_TIME_TAG = 4;
    public static final int UTC_OFFSET_TAG = 10;
    public static final int YEAR_MONTH_TAG = 11;

    public Ser(int typeTag, @Nullable Object value2) {
        this.typeTag = typeTag;
        this.value = value2;
    }

    public Ser() {
        this(0, null);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeByte(this.typeTag);
        Object value2 = this.value;
        switch (this.typeTag) {
            case 2: {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlinx.datetime.LocalDate");
                LocalDate cfr_ignored_0 = (LocalDate)value2;
                out.writeLong(((LocalDate)value2).getValue$kotlinx_datetime().toEpochDay());
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlinx.datetime.LocalTime");
                LocalTime cfr_ignored_1 = (LocalTime)value2;
                out.writeLong(((LocalTime)value2).toNanosecondOfDay());
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlinx.datetime.LocalDateTime");
                LocalDateTime cfr_ignored_2 = (LocalDateTime)value2;
                out.writeLong(((LocalDateTime)value2).getDate().getValue$kotlinx_datetime().toEpochDay());
                out.writeLong(((LocalDateTime)value2).getTime().toNanosecondOfDay());
                break;
            }
            case 10: {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlinx.datetime.UtcOffset");
                UtcOffset cfr_ignored_3 = (UtcOffset)value2;
                out.writeInt(((UtcOffset)value2).getTotalSeconds());
                break;
            }
            case 11: {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlinx.datetime.YearMonth");
                YearMonth cfr_ignored_4 = (YearMonth)value2;
                out.writeLong(YearMonthJvmKt.toEpochMonths((YearMonth)value2));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type tag: " + this.typeTag + " for value: " + value2);
            }
        }
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.typeTag = in.readByte();
        switch (this.typeTag) {
            case 2: {
                java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(in.readLong());
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(...)");
                serializable = new LocalDate(localDate);
                break;
            }
            case 3: {
                serializable = LocalTime.Companion.fromNanosecondOfDay(in.readLong());
                break;
            }
            case 4: {
                java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(in.readLong());
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(...)");
                serializable = new LocalDateTime(new LocalDate(localDate), LocalTime.Companion.fromNanosecondOfDay(in.readLong()));
                break;
            }
            case 10: {
                serializable = UtcOffsetJvmKt.UtcOffset$default(null, null, in.readInt(), 3, null);
                break;
            }
            case 11: {
                serializable = YearMonthJvmKt.fromEpochMonths(YearMonth.Companion, in.readLong());
                break;
            }
            default: {
                throw new IOException("Unknown type tag: " + this.typeTag);
            }
        }
        this.value = serializable;
    }

    private final Object readResolve() {
        Object object = this.value;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/Ser$Companion;", "", "<init>", "()V", "", "serialVersionUID", "J", "", "DATE_TAG", "I", "TIME_TAG", "DATE_TIME_TAG", "UTC_OFFSET_TAG", "YEAR_MONTH_TAG", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

