/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime;

import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.FixedOffsetTimeZone;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.IllegalTimeZoneException;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.LocalDateTime;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.OverloadMarker;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.TimeZoneKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.TimeZoneKt__TimeZoneJvmKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.UtcOffset;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.serializers.TimeZoneSerializer;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=TimeZoneSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u0007*\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\f\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;", "", "Ljava/time/ZoneId;", "zoneId", "<init>", "(Ljava/time/ZoneId;)V", "Lkotlin/time/Instant;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDateTime;", "toLocalDateTime", "(Lkotlin/time/Instant;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDateTime;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/OverloadMarker;", "youShallNotPass", "toInstant", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDateTime;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/OverloadMarker;)Lkotlin/time/Instant;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/time/ZoneId;", "getZoneId$kotlinx_datetime", "()Ljava/time/ZoneId;", "getId", "id", "Companion", "kotlinx-datetime"})
public class TimeZone {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoneId zoneId;
    @NotNull
    private static final FixedOffsetTimeZone UTC;

    public TimeZone(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.zoneId = zoneId;
    }

    @NotNull
    public final ZoneId getZoneId$kotlinx_datetime() {
        return this.zoneId;
    }

    @NotNull
    public final String getId() {
        String string = this.zoneId.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull Instant $this$toLocalDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"<this>");
        return TimeZoneKt.toLocalDateTime($this$toLocalDateTime, this);
    }

    @NotNull
    public final Instant toInstant(@NotNull LocalDateTime $this$toInstant, @NotNull OverloadMarker youShallNotPass) {
        Intrinsics.checkNotNullParameter((Object)$this$toInstant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)youShallNotPass, (String)"youShallNotPass");
        return TimeZoneKt.toInstant$default($this$toInstant, this, null, 2, null);
    }

    public static /* synthetic */ Instant toInstant$default(TimeZone timeZone, LocalDateTime localDateTime, OverloadMarker overloadMarker, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toInstant");
        }
        if ((n & 1) != 0) {
            overloadMarker = OverloadMarker.Companion.getINSTANCE$kotlinx_datetime();
        }
        return timeZone.toInstant(localDateTime, overloadMarker);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TimeZone && Intrinsics.areEqual((Object)this.zoneId, (Object)((TimeZone)other).zoneId);
    }

    public int hashCode() {
        return this.zoneId.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.zoneId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        UtcOffset utcOffset = UtcOffset.Companion.getZERO();
        ZoneId zoneId = ZoneId.of("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
        UTC = new FixedOffsetTimeZone(utcOffset, zoneId);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone$Companion;", "", "<init>", "()V", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;", "currentSystemDefault", "()Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;", "", "zoneId", "of", "(Ljava/lang/String;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;", "Ljava/time/ZoneId;", "ofZone$kotlinx_datetime", "(Ljava/time/ZoneId;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/TimeZone;", "ofZone", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/FixedOffsetTimeZone;", "UTC", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/FixedOffsetTimeZone;", "getUTC", "()Lkotlinx/datetime/FixedOffsetTimeZone;", "", "getAvailableZoneIds", "()Ljava/util/Set;", "availableZoneIds", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeZone currentSystemDefault() {
            ZoneId zoneId = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"systemDefault(...)");
            return this.ofZone$kotlinx_datetime(zoneId);
        }

        @NotNull
        public final FixedOffsetTimeZone getUTC() {
            return UTC;
        }

        @NotNull
        public final TimeZone of(@NotNull String zoneId) {
            TimeZone timeZone;
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            try {
                ZoneId zoneId2 = ZoneId.of(Intrinsics.areEqual((Object)zoneId, (Object)"z") ? "Z" : zoneId);
                Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(...)");
                timeZone = this.ofZone$kotlinx_datetime(zoneId2);
            }
            catch (Exception e) {
                if (e instanceof DateTimeException) {
                    throw new IllegalTimeZoneException(e);
                }
                throw e;
            }
            return timeZone;
        }

        @NotNull
        public final TimeZone ofZone$kotlinx_datetime(@NotNull ZoneId zoneId) {
            TimeZone timeZone;
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            if (zoneId instanceof ZoneOffset) {
                timeZone = new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId));
            } else if (TimeZoneKt__TimeZoneJvmKt.access$isFixedOffset(zoneId)) {
                ZoneId zoneId2 = zoneId.normalized();
                Intrinsics.checkNotNull((Object)zoneId2, (String)"null cannot be cast to non-null type java.time.ZoneOffset");
                timeZone = new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId2), zoneId);
            } else {
                timeZone = new TimeZone(zoneId);
            }
            return timeZone;
        }

        @NotNull
        public final Set<String> getAvailableZoneIds() {
            Set<String> set = ZoneId.getAvailableZoneIds();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAvailableZoneIds(...)");
            return set;
        }

        @NotNull
        public final KSerializer<TimeZone> serializer() {
            return TimeZoneSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

