/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime;

import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimeUnit;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.YearMonth;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.YearMonthKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.YearMonthProgressionIterator;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.MathKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.LongProgression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\b\u0016\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001-B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!R\u001a\u0010\u0004\u001a\u00020\u00038\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b)\u0010&\u001a\u0004\b*\u0010(R\u0014\u0010,\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010!\u00a8\u0006."}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonthProgression;", "", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "Lkotlin/ranges/LongProgression;", "longProgression", "<init>", "(Lkotlin/ranges/LongProgression;)V", "start", "endInclusive", "", "step", "(Lkotlinx/datetime/YearMonth;Lkotlinx/datetime/YearMonth;J)V", "", "iterator", "()Ljava/util/Iterator;", "", "isEmpty", "()Z", "", "toString", "()Ljava/lang/String;", "elements", "containsAll", "(Ljava/util/Collection;)Z", "value", "contains", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;)Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lkotlin/ranges/LongProgression;", "getLongProgression$kotlinx_datetime", "()Lkotlin/ranges/LongProgression;", "first", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "getFirst", "()Lkotlinx/datetime/YearMonth;", "last", "getLast", "getSize", "size", "Companion", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nYearMonthRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YearMonthRange.kt\nkotlinx/datetime/YearMonthProgression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1740#2,3:279\n*S KotlinDebug\n*F\n+ 1 YearMonthRange.kt\nkotlinx/datetime/YearMonthProgression\n*L\n73#1:279,3\n*E\n"})
public class YearMonthProgression
implements Collection<YearMonth>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LongProgression longProgression;
    @NotNull
    private final YearMonth first;
    @NotNull
    private final YearMonth last;

    public YearMonthProgression(@NotNull LongProgression longProgression) {
        Intrinsics.checkNotNullParameter((Object)longProgression, (String)"longProgression");
        this.longProgression = longProgression;
        this.first = YearMonthKt.fromProlepticMonth(YearMonth.Companion, this.longProgression.getFirst());
        this.last = YearMonthKt.fromProlepticMonth(YearMonth.Companion, this.longProgression.getLast());
    }

    @NotNull
    public final LongProgression getLongProgression$kotlinx_datetime() {
        return this.longProgression;
    }

    public YearMonthProgression(@NotNull YearMonth start2, @NotNull YearMonth endInclusive, long step) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this(LongProgression.Companion.fromClosedRange(YearMonthKt.getProlepticMonth(start2), YearMonthKt.getProlepticMonth(endInclusive), step));
    }

    @NotNull
    public final YearMonth getFirst() {
        return this.first;
    }

    @NotNull
    public final YearMonth getLast() {
        return this.last;
    }

    @Override
    @NotNull
    public Iterator<YearMonth> iterator() {
        return new YearMonthProgressionIterator(this.longProgression.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.longProgression.isEmpty();
    }

    @NotNull
    public String toString() {
        return this.longProgression.getStep() > 0L ? this.first + ".." + this.last + " step " + this.longProgression.getStep() + 'M' : this.first + " downTo " + this.last + " step " + this.longProgression.getStep() + 'M';
    }

    public int getSize() {
        return MathKt.getSizeUnsafe(this.longProgression);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (it instanceof YearMonth && this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean contains(@NotNull YearMonth value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return MathKt.containsUnsafe(this.longProgression, YearMonthKt.getProlepticMonth(value2));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof YearMonthProgression && Intrinsics.areEqual((Object)this.longProgression, (Object)((YearMonthProgression)other).longProgression);
    }

    @Override
    public int hashCode() {
        return this.longProgression.hashCode();
    }

    @Override
    public boolean add(YearMonth element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends YearMonth> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super YearMonth> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonthProgression$Companion;", "", "<init>", "()V", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "rangeStart", "rangeEnd", "", "stepValue", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$MonthBased;", "stepUnit", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonthProgression;", "fromClosedRange$kotlinx_datetime", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;JLio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$MonthBased;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonthProgression;", "fromClosedRange", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final YearMonthProgression fromClosedRange$kotlinx_datetime(@NotNull YearMonth rangeStart, @NotNull YearMonth rangeEnd, long stepValue, @NotNull DateTimeUnit.MonthBased stepUnit) {
            Intrinsics.checkNotNullParameter((Object)rangeStart, (String)"rangeStart");
            Intrinsics.checkNotNullParameter((Object)rangeEnd, (String)"rangeEnd");
            Intrinsics.checkNotNullParameter((Object)stepUnit, (String)"stepUnit");
            return new YearMonthProgression(rangeStart, rangeEnd, MathKt.safeMultiplyOrClamp(stepValue, stepUnit.getMonths()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

