/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.inventory;

import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.builder.AbstractBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.inventory.BookImpl;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.Buildable;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.examination.Examinable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface Book
extends Buildable<Book, Builder>,
Examinable {
    @NotNull
    public static Book book(@NotNull Component title2, @NotNull Component author2, @NotNull Collection<Component> pages) {
        return new BookImpl(title2, author2, new ArrayList<Component>(pages));
    }

    @NotNull
    public static Book book(@NotNull Component title2, @NotNull Component author2, Component ... pages) {
        return Book.book(title2, author2, Arrays.asList(pages));
    }

    @NotNull
    public static Builder builder() {
        return new BookImpl.BuilderImpl();
    }

    @NotNull
    public Component title();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Book title(@NotNull Component var1);

    @NotNull
    public Component author();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Book author(@NotNull Component var1);

    public @Unmodifiable @NotNull List<Component> pages();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public Book pages(Component ... pages) {
        return this.pages(Arrays.asList(pages));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Book pages(@NotNull List<Component> var1);

    @Override
    @NotNull
    default public Builder toBuilder() {
        return Book.builder().title(this.title()).author(this.author()).pages(this.pages());
    }

    public static interface Builder
    extends AbstractBuilder<Book>,
    Buildable.Builder<Book> {
        @Contract(value="_ -> this")
        @NotNull
        public Builder title(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder author(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder addPage(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder pages(Component ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder pages(@NotNull Collection<Component> var1);

        @Override
        @NotNull
        public Book build();
    }
}

