/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.inventory;

import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.internal.Internals;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.inventory.Book;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.examination.ExaminableProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class BookImpl
implements Book {
    private final Component title;
    private final Component author;
    private final List<Component> pages;

    BookImpl(@NotNull Component title2, @NotNull Component author2, @NotNull List<Component> pages) {
        this.title = Objects.requireNonNull(title2, "title");
        this.author = Objects.requireNonNull(author2, "author");
        this.pages = Collections.unmodifiableList(Objects.requireNonNull(pages, "pages"));
    }

    @Override
    @NotNull
    public Component title() {
        return this.title;
    }

    @Override
    @NotNull
    public Book title(@NotNull Component title2) {
        return new BookImpl(Objects.requireNonNull(title2, "title"), this.author, this.pages);
    }

    @Override
    @NotNull
    public Component author() {
        return this.author;
    }

    @Override
    @NotNull
    public Book author(@NotNull Component author2) {
        return new BookImpl(this.title, Objects.requireNonNull(author2, "author"), this.pages);
    }

    @Override
    @NotNull
    public List<Component> pages() {
        return this.pages;
    }

    @Override
    @NotNull
    public Book pages(@NotNull List<Component> pages) {
        return new BookImpl(this.title, this.author, new ArrayList<Component>((Collection)Objects.requireNonNull(pages, "pages")));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("title", this.title), ExaminableProperty.of("author", this.author), ExaminableProperty.of("pages", this.pages));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BookImpl)) {
            return false;
        }
        BookImpl that = (BookImpl)o;
        return this.title.equals(that.title) && this.author.equals(that.author) && this.pages.equals(that.pages);
    }

    public int hashCode() {
        int result2 = this.title.hashCode();
        result2 = 31 * result2 + this.author.hashCode();
        result2 = 31 * result2 + this.pages.hashCode();
        return result2;
    }

    public String toString() {
        return Internals.toString(this);
    }

    static final class BuilderImpl
    implements Book.Builder {
        private Component title = Component.empty();
        private Component author = Component.empty();
        private final List<Component> pages = new ArrayList<Component>();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public Book.Builder title(@NotNull Component title2) {
            this.title = Objects.requireNonNull(title2, "title");
            return this;
        }

        @Override
        @NotNull
        public Book.Builder author(@NotNull Component author2) {
            this.author = Objects.requireNonNull(author2, "author");
            return this;
        }

        @Override
        @NotNull
        public Book.Builder addPage(@NotNull Component page) {
            this.pages.add(Objects.requireNonNull(page, "page"));
            return this;
        }

        @Override
        @NotNull
        public Book.Builder pages(@NotNull Collection<Component> pages) {
            this.pages.addAll(Objects.requireNonNull(pages, "pages"));
            return this;
        }

        @Override
        @NotNull
        public Book.Builder pages(Component ... pages) {
            Collections.addAll(this.pages, pages);
            return this;
        }

        @Override
        @NotNull
        public Book build() {
            return new BookImpl(this.title, this.author, new ArrayList<Component>(this.pages));
        }
    }
}

