/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key;

import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.InvalidKeyException;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.Key;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.examination.ExaminableProperty;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;

final class KeyImpl
implements Key {
    static final Comparator<? super Key> COMPARATOR = Comparator.comparing(Key::value).thenComparing(Key::namespace);
    @RegExp
    static final String NAMESPACE_PATTERN = "[a-z0-9_\\-.]+";
    @RegExp
    static final String VALUE_PATTERN = "[a-z0-9_\\-./]+";
    private final String namespace;
    private final String value;

    KeyImpl(@NotNull String namespace, @NotNull String value2) {
        KeyImpl.checkError("namespace", namespace, namespace, value2, Key.checkNamespace(namespace), NAMESPACE_PATTERN);
        KeyImpl.checkError("value", value2, namespace, value2, Key.checkValue(value2), VALUE_PATTERN);
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.value = Objects.requireNonNull(value2, "value");
    }

    private static void checkError(String name2, String checkPart, String namespace, String value2, OptionalInt index, String pattern) {
        if (index.isPresent()) {
            int indexValue = index.getAsInt();
            char character = checkPart.charAt(indexValue);
            throw new InvalidKeyException(namespace, value2, String.format("Non " + pattern + " character in %s of Key[%s] at index %d ('%s', bytes: %s)", name2, KeyImpl.asString(namespace, value2), indexValue, Character.valueOf(character), Arrays.toString(String.valueOf(character).getBytes(StandardCharsets.UTF_8))));
        }
    }

    static boolean allowedInNamespace(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    static boolean allowedInValue(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.' || character == '/';
    }

    @Override
    @NotNull
    public String namespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public String value() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        return KeyImpl.asString(this.namespace, this.value);
    }

    @NotNull
    private static String asString(@NotNull String namespace, @NotNull String value2) {
        return namespace + ':' + value2;
    }

    @NotNull
    public String toString() {
        return this.asString();
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace), ExaminableProperty.of("value", this.value));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Key)) {
            return false;
        }
        Key that = (Key)other;
        return Objects.equals(this.namespace, that.namespace()) && Objects.equals(this.value, that.value());
    }

    public int hashCode() {
        int result2 = this.namespace.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }

    @Override
    public int compareTo(@NotNull Key that) {
        return Key.super.compareTo(that);
    }
}

