/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.sound;

import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.builder.AbstractBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.Key;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.Keyed;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.sound.SoundImpl;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.sound.SoundStop;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.Index;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.examination.Examinable;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@ApiStatus.NonExtendable
public interface Sound
extends Examinable {
    @NotNull
    public static Builder sound() {
        return new SoundImpl.BuilderImpl();
    }

    @NotNull
    public static Builder sound(@NotNull Sound existing) {
        return new SoundImpl.BuilderImpl(existing);
    }

    @NotNull
    public static Sound sound(@NotNull Consumer<Builder> configurer) {
        return (Sound)AbstractBuilder.configureAndBuild(Sound.sound(), configurer);
    }

    @NotNull
    public static Sound sound(@NotNull Key name2, @NotNull Source source2, float volume2, float pitch) {
        return (Sound)Sound.sound().type(name2).source(source2).volume(volume2).pitch(pitch).build();
    }

    @NotNull
    public static Sound sound(@NotNull Type type, @NotNull Source source2, float volume2, float pitch) {
        Objects.requireNonNull(type, "type");
        return Sound.sound(type.key(), source2, volume2, pitch);
    }

    @NotNull
    public static Sound sound(@NotNull Supplier<? extends Type> type, @NotNull Source source2, float volume2, float pitch) {
        return (Sound)Sound.sound().type(type).source(source2).volume(volume2).pitch(pitch).build();
    }

    @NotNull
    public static Sound sound(@NotNull Key name2, @NotNull Source.Provider source2, float volume2, float pitch) {
        return Sound.sound(name2, source2.soundSource(), volume2, pitch);
    }

    @NotNull
    public static Sound sound(@NotNull Type type, @NotNull Source.Provider source2, float volume2, float pitch) {
        return Sound.sound(type, source2.soundSource(), volume2, pitch);
    }

    @NotNull
    public static Sound sound(@NotNull Supplier<? extends Type> type, @NotNull Source.Provider source2, float volume2, float pitch) {
        return Sound.sound(type, source2.soundSource(), volume2, pitch);
    }

    @NotNull
    public Key name();

    @NotNull
    public Source source();

    public float volume();

    public float pitch();

    @NotNull
    public OptionalLong seed();

    @NotNull
    public SoundStop asStop();

    public static interface Builder
    extends AbstractBuilder<Sound> {
        @NotNull
        public Builder type(@NotNull Key var1);

        @NotNull
        public Builder type(@NotNull Type var1);

        @NotNull
        public Builder type(@NotNull Supplier<? extends Type> var1);

        @NotNull
        public Builder source(@NotNull Source var1);

        @NotNull
        public Builder source(@NotNull Source.Provider var1);

        @NotNull
        public Builder volume(@Range(from=0L, to=0x7FFFFFFFL) float var1);

        @NotNull
        public Builder pitch(@Range(from=-1L, to=1L) float var1);

        @NotNull
        public Builder seed(long var1);

        @NotNull
        public Builder seed(@NotNull OptionalLong var1);
    }

    public static enum Source {
        MASTER("master"),
        MUSIC("music"),
        RECORD("record"),
        WEATHER("weather"),
        BLOCK("block"),
        HOSTILE("hostile"),
        NEUTRAL("neutral"),
        PLAYER("player"),
        AMBIENT("ambient"),
        VOICE("voice"),
        UI("ui");

        public static final Index<String, Source> NAMES;
        private final String name;

        private Source(String name2) {
            this.name = name2;
        }

        static {
            NAMES = Index.create(Source.class, source2 -> source2.name);
        }

        public static interface Provider {
            @NotNull
            public Source soundSource();
        }
    }

    public static interface Type
    extends Keyed {
        @Override
        @NotNull
        public Key key();
    }

    public static interface Emitter {
        @NotNull
        public static Emitter self() {
            return SoundImpl.EMITTER_SELF;
        }
    }
}

