/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text;

import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.ComponentLike;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.PatternReplacementResult;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TextComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TextReplacementConfig;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TranslatableComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TranslationArgument;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.event.HoverEvent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.event.HoverEventSource;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.Style;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.StyleSetter;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.renderer.ComponentRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextReplacementRenderer
implements ComponentRenderer<State> {
    static final TextReplacementRenderer INSTANCE = new TextReplacementRenderer();

    private TextReplacementRenderer() {
    }

    @Override
    @NotNull
    public Component render(@NotNull Component component, @NotNull State state2) {
        if (!state2.running) {
            return component;
        }
        boolean prevFirstMatch = state2.firstMatch;
        state2.firstMatch = true;
        List<Component> oldChildren = component.children();
        int oldChildrenSize = oldChildren.size();
        StyleSetter<Style> oldStyle = component.style();
        ArrayList<TextComponent> children = null;
        Component modified = component;
        if (component instanceof TextComponent) {
            String content2 = ((TextComponent)component).content();
            Matcher matcher = state2.pattern.matcher(content2);
            int replacedUntil = 0;
            while (matcher.find()) {
                PatternReplacementResult result2;
                if ((result2 = state2.continuer.shouldReplace(matcher, ++state2.matchCount, state2.replaceCount)) == PatternReplacementResult.CONTINUE) continue;
                if (result2 == PatternReplacementResult.STOP) {
                    state2.running = false;
                    break;
                }
                if (matcher.start() == 0) {
                    if (matcher.end() == content2.length()) {
                        ComponentLike replacement = state2.replacement.apply(matcher, (TextComponent.Builder)Component.text().content(matcher.group()).style(component.style()));
                        Component component2 = modified = replacement == null ? Component.empty() : replacement.asComponent();
                        if (modified.style().hoverEvent() != null) {
                            oldStyle = oldStyle.hoverEvent((HoverEventSource)null);
                        }
                        modified = modified.style(modified.style().merge(component.style(), Style.Merge.Strategy.IF_ABSENT_ON_TARGET));
                        if (children == null) {
                            children = new ArrayList(oldChildrenSize + modified.children().size());
                            children.addAll(modified.children());
                        }
                    } else {
                        modified = Component.text("", component.style());
                        ComponentLike child = state2.replacement.apply(matcher, Component.text().content(matcher.group()));
                        if (child != null) {
                            if (children == null) {
                                children = new ArrayList(oldChildrenSize + 1);
                            }
                            children.add((TextComponent)child.asComponent());
                        }
                    }
                } else {
                    if (children == null) {
                        children = new ArrayList(oldChildrenSize + 2);
                    }
                    if (state2.firstMatch) {
                        modified = ((TextComponent)component).content(content2.substring(0, matcher.start()));
                    } else if (replacedUntil < matcher.start()) {
                        children.add(Component.text(content2.substring(replacedUntil, matcher.start())));
                    }
                    ComponentLike builder2 = state2.replacement.apply(matcher, Component.text().content(matcher.group()));
                    if (builder2 != null) {
                        children.add((TextComponent)builder2.asComponent());
                    }
                }
                ++state2.replaceCount;
                state2.firstMatch = false;
                replacedUntil = matcher.end();
            }
            if (replacedUntil < content2.length() && replacedUntil > 0) {
                if (children == null) {
                    children = new ArrayList<TextComponent>(oldChildrenSize);
                }
                children.add(Component.text(content2.substring(replacedUntil)));
            }
        } else if (modified instanceof TranslatableComponent) {
            List<TranslationArgument> args = ((TranslatableComponent)modified).arguments();
            ArrayList<TranslationArgument> newArgs = null;
            int size = args.size();
            for (int i = 0; i < size; ++i) {
                TranslationArgument replaced;
                TranslationArgument original = args.get(i);
                TranslationArgument translationArgument = replaced = original.value() instanceof Component ? TranslationArgument.component(this.render((Component)original.value(), state2)) : original;
                if (replaced != original && newArgs == null) {
                    newArgs = new ArrayList<TranslationArgument>(size);
                    if (i > 0) {
                        newArgs.addAll(args.subList(0, i));
                    }
                }
                if (newArgs == null) continue;
                newArgs.add(replaced);
            }
            if (newArgs != null) {
                modified = ((TranslatableComponent)modified).arguments(newArgs);
            }
        }
        if (state2.running) {
            HoverEvent<?> rendered;
            HoverEvent<?> event2;
            if (state2.replaceInsideHoverEvents && (event2 = oldStyle.hoverEvent()) != null && event2 != (rendered = event2.withRenderedValue(this, state2))) {
                modified = modified.style(s -> s.hoverEvent(rendered));
            }
            boolean first = true;
            for (int i = 0; i < oldChildrenSize; ++i) {
                Component child = oldChildren.get(i);
                Component replaced = this.render(child, state2);
                if (replaced != child) {
                    if (children == null) {
                        children = new ArrayList(oldChildrenSize);
                    }
                    if (first) {
                        children.addAll(oldChildren.subList(0, i));
                    }
                    first = false;
                }
                if (children == null) continue;
                children.add((TextComponent)replaced);
                first = false;
            }
        } else if (children != null) {
            children.addAll(oldChildren);
        }
        state2.firstMatch = prevFirstMatch;
        if (children != null) {
            return modified.children((List<? extends ComponentLike>)children);
        }
        return modified;
    }

    static final class State {
        final Pattern pattern;
        final BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
        final TextReplacementConfig.Condition continuer;
        final boolean replaceInsideHoverEvents;
        boolean running = true;
        int matchCount = 0;
        int replaceCount = 0;
        boolean firstMatch = true;

        State(@NotNull Pattern pattern, @NotNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement, @NotNull TextReplacementConfig.Condition continuer, boolean replaceInsideHoverEvents) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.continuer = continuer;
            this.replaceInsideHoverEvents = replaceInsideHoverEvents;
        }
    }
}

