/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.Key;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.BlockNBTComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.BuildableComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.ComponentBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.ComponentLike;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.EntityNBTComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.KeybindComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.NBTComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.NBTComponentBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.ObjectComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.ScoreComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.SelectorComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.StorageNBTComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TextComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TranslatableComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TranslationArgument;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.Style;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.object.ObjectContents;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.object.PlayerHeadObjectContents;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.object.SpriteObjectContents;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.GsonHacks;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.SerializerFactory;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.json.JSONOptions;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.Buildable;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionState;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

final class ComponentSerializerImpl
extends TypeAdapter<Component> {
    static final Type COMPONENT_LIST_TYPE = new TypeToken<List<Component>>(){}.getType();
    static final Type TRANSLATABLE_ARGUMENT_LIST_TYPE = new TypeToken<List<TranslationArgument>>(){}.getType();
    static final Type PROPERTY_LIST_TYPE = new TypeToken<List<PlayerHeadObjectContents.ProfileProperty>>(){}.getType();
    private final boolean emitCompactTextComponent;
    private final Gson gson;

    static TypeAdapter<Component> create(OptionState features2, Gson gson) {
        return new ComponentSerializerImpl(features2.value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT), gson).nullSafe();
    }

    private ComponentSerializerImpl(boolean emitCompactTextComponent, Gson gson) {
        this.emitCompactTextComponent = emitCompactTextComponent;
        this.gson = gson;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildableComponent<?, ?> read(JsonReader in) throws IOException {
        ComponentBuilder<TextComponent, TextComponent.Builder> builder2;
        JsonToken token = in.peek();
        if (token == JsonToken.STRING || token == JsonToken.NUMBER || token == JsonToken.BOOLEAN) {
            return Component.text(GsonHacks.readString(in));
        }
        if (token == JsonToken.BEGIN_ARRAY) {
            void var3_4;
            Object var3_3 = null;
            in.beginArray();
            while (in.hasNext()) {
                Object child = this.read(in);
                if (var3_4 == null) {
                    Buildable.Builder builder3 = child.toBuilder();
                    continue;
                }
                var3_4.append((Component)child);
            }
            if (var3_4 == null) {
                throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
            }
            in.endArray();
            return var3_4.build();
        }
        if (token != JsonToken.BEGIN_OBJECT) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
        }
        JsonObject jsonObject = new JsonObject();
        List extra = Collections.emptyList();
        String text = null;
        String translate2 = null;
        String translateFallback = null;
        List translateWith = null;
        String scoreName = null;
        String scoreObjective = null;
        String scoreValue = null;
        String selector = null;
        String keybind = null;
        String nbt = null;
        boolean nbtInterpret = false;
        BlockNBTComponent.Pos nbtBlock = null;
        String nbtEntity = null;
        Key nbtStorage = null;
        Object separator = null;
        Key atlas = null;
        Key sprite = null;
        PlayerHeadObjectContents.Builder playerHeadContents = null;
        boolean playerHeadContentsHasProfile = false;
        in.beginObject();
        while (in.hasNext()) {
            String fieldName = in.nextName();
            if (fieldName.equals("text")) {
                text = GsonHacks.readString(in);
                continue;
            }
            if (fieldName.equals("translate")) {
                translate2 = in.nextString();
                continue;
            }
            if (fieldName.equals("fallback")) {
                translateFallback = in.nextString();
                continue;
            }
            if (fieldName.equals("with")) {
                translateWith = (List)this.gson.fromJson(in, TRANSLATABLE_ARGUMENT_LIST_TYPE);
                continue;
            }
            if (fieldName.equals("score")) {
                in.beginObject();
                while (in.hasNext()) {
                    String scoreFieldName = in.nextName();
                    if (scoreFieldName.equals("name")) {
                        scoreName = in.nextString();
                        continue;
                    }
                    if (scoreFieldName.equals("objective")) {
                        scoreObjective = in.nextString();
                        continue;
                    }
                    if (scoreFieldName.equals("value")) {
                        scoreValue = in.nextString();
                        continue;
                    }
                    in.skipValue();
                }
                if (scoreName == null || scoreObjective == null) {
                    throw new JsonParseException("A score component requires a name and objective");
                }
                in.endObject();
                continue;
            }
            if (fieldName.equals("selector")) {
                selector = in.nextString();
                continue;
            }
            if (fieldName.equals("keybind")) {
                keybind = in.nextString();
                continue;
            }
            if (fieldName.equals("nbt")) {
                nbt = in.nextString();
                continue;
            }
            if (fieldName.equals("interpret")) {
                nbtInterpret = in.nextBoolean();
                continue;
            }
            if (fieldName.equals("block")) {
                nbtBlock = (BlockNBTComponent.Pos)this.gson.fromJson(in, SerializerFactory.BLOCK_NBT_POS_TYPE);
                continue;
            }
            if (fieldName.equals("entity")) {
                nbtEntity = in.nextString();
                continue;
            }
            if (fieldName.equals("storage")) {
                nbtStorage = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (fieldName.equals("extra")) {
                extra = (List)this.gson.fromJson(in, COMPONENT_LIST_TYPE);
                continue;
            }
            if (fieldName.equals("separator")) {
                separator = this.read(in);
                continue;
            }
            if (fieldName.equals("atlas")) {
                atlas = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (fieldName.equals("sprite")) {
                sprite = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (fieldName.equals("player")) {
                JsonToken playerToken;
                if (playerHeadContents == null) {
                    playerHeadContents = ObjectContents.playerHead();
                }
                if ((playerToken = in.peek()) == JsonToken.STRING) {
                    playerHeadContentsHasProfile = true;
                    playerHeadContents.name(in.nextString());
                    continue;
                }
                if (playerToken == JsonToken.BEGIN_OBJECT) {
                    playerHeadContentsHasProfile = true;
                    in.beginObject();
                    while (in.hasNext()) {
                        String playerHeadFieldName = in.nextName();
                        if (playerHeadFieldName.equals("name")) {
                            playerHeadContents.name(in.nextString());
                            continue;
                        }
                        if (playerHeadFieldName.equals("id")) {
                            playerHeadContents.id((UUID)this.gson.fromJson(in, SerializerFactory.UUID_TYPE));
                            continue;
                        }
                        if (playerHeadFieldName.equals("properties")) {
                            JsonToken propertyToken = in.peek();
                            if (propertyToken == JsonToken.BEGIN_ARRAY) {
                                playerHeadContents.profileProperties((Collection)this.gson.fromJson(in, PROPERTY_LIST_TYPE));
                                continue;
                            }
                            if (propertyToken == JsonToken.BEGIN_OBJECT) {
                                in.beginObject();
                                while (in.hasNext()) {
                                    String propertyName = in.nextName();
                                    in.beginArray();
                                    while (in.hasNext()) {
                                        playerHeadContents.profileProperty(PlayerHeadObjectContents.property(propertyName, in.nextString()));
                                    }
                                    in.endArray();
                                }
                                in.endObject();
                                continue;
                            }
                            in.skipValue();
                            continue;
                        }
                        if (playerHeadFieldName.equals("texture")) {
                            playerHeadContents.texture((Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE));
                            continue;
                        }
                        in.skipValue();
                    }
                    in.endObject();
                    continue;
                }
                in.skipValue();
                continue;
            }
            if (fieldName.equals("hat")) {
                if (playerHeadContents == null) {
                    playerHeadContents = ObjectContents.playerHead();
                }
                playerHeadContents.hat(in.nextBoolean());
                continue;
            }
            jsonObject.add(fieldName, (JsonElement)this.gson.fromJson(in, JsonElement.class));
        }
        if (text != null) {
            builder2 = Component.text().content(text);
        } else if (translate2 != null) {
            builder2 = translateWith != null ? Component.translatable().key(translate2).fallback(translateFallback).arguments(translateWith) : Component.translatable().key(translate2).fallback(translateFallback);
        } else if (scoreName != null && scoreObjective != null) {
            builder2 = scoreValue == null ? Component.score().name(scoreName).objective(scoreObjective) : Component.score().name(scoreName).objective(scoreObjective).value(scoreValue);
        } else if (selector != null) {
            builder2 = Component.selector().pattern(selector).separator((ComponentLike)separator);
        } else if (keybind != null) {
            builder2 = Component.keybind().keybind(keybind);
        } else if (nbt != null) {
            if (nbtBlock != null) {
                builder2 = ComponentSerializerImpl.nbt(Component.blockNBT(), nbt, nbtInterpret, separator).pos(nbtBlock);
            } else if (nbtEntity != null) {
                builder2 = ComponentSerializerImpl.nbt(Component.entityNBT(), nbt, nbtInterpret, separator).selector(nbtEntity);
            } else {
                if (nbtStorage == null) throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
                builder2 = ComponentSerializerImpl.nbt(Component.storageNBT(), nbt, nbtInterpret, separator).storage(nbtStorage);
            }
        } else if (sprite != null) {
            builder2 = Component.object().contents(ObjectContents.sprite(atlas != null ? atlas : SpriteObjectContents.DEFAULT_ATLAS, sprite));
        } else {
            if (playerHeadContents == null || !playerHeadContentsHasProfile) throw ComponentSerializerImpl.notSureHowToDeserialize(in.getPath());
            builder2 = Component.object().contents(playerHeadContents.build());
        }
        builder2.style((Style)this.gson.fromJson((JsonElement)jsonObject, SerializerFactory.STYLE_TYPE)).append(extra);
        in.endObject();
        return builder2.build();
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder2, String nbt, boolean interpret, @Nullable Component separator) {
        return builder2.nbtPath(nbt).interpret(interpret).separator(separator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(JsonWriter out, Component value2) throws IOException {
        JsonElement style;
        if (value2 instanceof TextComponent && value2.children().isEmpty() && !value2.hasStyling() && this.emitCompactTextComponent) {
            out.value(((TextComponent)value2).content());
            return;
        }
        out.beginObject();
        if (value2.hasStyling() && (style = this.gson.toJsonTree((Object)value2.style(), SerializerFactory.STYLE_TYPE)).isJsonObject()) {
            for (Map.Entry entry : style.getAsJsonObject().entrySet()) {
                out.name((String)entry.getKey());
                this.gson.toJson((JsonElement)entry.getValue(), out);
            }
        }
        if (!value2.children().isEmpty()) {
            out.name("extra");
            this.gson.toJson(value2.children(), COMPONENT_LIST_TYPE, out);
        }
        if (value2 instanceof TextComponent) {
            out.name("text");
            out.value(((TextComponent)value2).content());
        } else if (value2 instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)value2;
            out.name("translate");
            out.value(translatable.key());
            @Nullable String fallback = translatable.fallback();
            if (fallback != null) {
                out.name("fallback");
                out.value(fallback);
            }
            if (!translatable.arguments().isEmpty()) {
                out.name("with");
                this.gson.toJson(translatable.arguments(), TRANSLATABLE_ARGUMENT_LIST_TYPE, out);
            }
        } else if (value2 instanceof ScoreComponent) {
            ScoreComponent score = (ScoreComponent)value2;
            out.name("score");
            out.beginObject();
            out.name("name");
            out.value(score.name());
            out.name("objective");
            out.value(score.objective());
            if (score.value() != null) {
                out.name("value");
                out.value(score.value());
            }
            out.endObject();
        } else if (value2 instanceof SelectorComponent) {
            SelectorComponent selector = (SelectorComponent)value2;
            out.name("selector");
            out.value(selector.pattern());
            this.serializeSeparator(out, selector.separator());
        } else if (value2 instanceof KeybindComponent) {
            out.name("keybind");
            out.value(((KeybindComponent)value2).keybind());
        } else if (value2 instanceof NBTComponent) {
            NBTComponent nbt = (NBTComponent)value2;
            out.name("nbt");
            out.value(nbt.nbtPath());
            out.name("interpret");
            out.value(nbt.interpret());
            this.serializeSeparator(out, nbt.separator());
            if (value2 instanceof BlockNBTComponent) {
                out.name("block");
                this.gson.toJson((Object)((BlockNBTComponent)value2).pos(), SerializerFactory.BLOCK_NBT_POS_TYPE, out);
            } else if (value2 instanceof EntityNBTComponent) {
                out.name("entity");
                out.value(((EntityNBTComponent)value2).selector());
            } else {
                if (!(value2 instanceof StorageNBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(value2);
                out.name("storage");
                this.gson.toJson((Object)((StorageNBTComponent)value2).storage(), SerializerFactory.KEY_TYPE, out);
            }
        } else {
            if (!(value2 instanceof ObjectComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(value2);
            ObjectComponent objectComponent = (ObjectComponent)value2;
            ObjectContents contents = objectComponent.contents();
            if (contents instanceof SpriteObjectContents) {
                SpriteObjectContents spriteContents = (SpriteObjectContents)contents;
                if (!spriteContents.atlas().equals(SpriteObjectContents.DEFAULT_ATLAS)) {
                    out.name("atlas");
                    this.gson.toJson((Object)spriteContents.atlas(), SerializerFactory.KEY_TYPE, out);
                }
                out.name("sprite");
                this.gson.toJson((Object)spriteContents.sprite(), SerializerFactory.KEY_TYPE, out);
            } else {
                if (!(contents instanceof PlayerHeadObjectContents)) throw ComponentSerializerImpl.notSureHowToSerialize(value2);
                PlayerHeadObjectContents playerHeadContents = (PlayerHeadObjectContents)contents;
                out.name("hat");
                out.value(playerHeadContents.hat());
                String playerName = playerHeadContents.name();
                UUID playerId = playerHeadContents.id();
                List<PlayerHeadObjectContents.ProfileProperty> properties = playerHeadContents.profileProperties();
                Key texture = playerHeadContents.texture();
                out.name("player");
                if (playerName != null && playerId == null && properties.isEmpty() && texture == null) {
                    out.value(playerName);
                } else {
                    out.beginObject();
                    if (playerName != null) {
                        out.name("name");
                        out.value(playerName);
                    }
                    if (playerId != null) {
                        out.name("id");
                        this.gson.toJson((Object)playerId, SerializerFactory.UUID_TYPE, out);
                    }
                    if (!properties.isEmpty()) {
                        out.name("properties");
                        this.gson.toJson(properties, PROPERTY_LIST_TYPE, out);
                    }
                    if (texture != null) {
                        out.name("texture");
                        this.gson.toJson((Object)texture, SerializerFactory.KEY_TYPE, out);
                    }
                    out.endObject();
                }
            }
        }
        out.endObject();
    }

    private void serializeSeparator(JsonWriter out, @Nullable Component separator) throws IOException {
        if (separator != null) {
            out.name("separator");
            this.write(out, separator);
        }
    }

    static JsonParseException notSureHowToDeserialize(Object element) {
        return new JsonParseException("Don't know how to turn " + element + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

