/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson;

import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextColor;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextDecoration;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.TextColorSerializer;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

final class TextColorWrapper {
    @Nullable
    final TextColor color;
    @Nullable
    final TextDecoration decoration;
    final boolean reset;

    TextColorWrapper(@Nullable TextColor color2, @Nullable TextDecoration decoration, boolean reset) {
        this.color = color2;
        this.decoration = decoration;
        this.reset = reset;
    }

    static final class Serializer
    extends TypeAdapter<TextColorWrapper> {
        static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void write(JsonWriter out, TextColorWrapper value2) {
            throw new JsonSyntaxException("Cannot write TextColorWrapper instances");
        }

        public TextColorWrapper read(JsonReader in) throws IOException {
            boolean reset;
            String input2 = in.nextString();
            TextColor color2 = TextColorSerializer.fromString(input2);
            TextDecoration decoration = TextDecoration.NAMES.value(input2);
            boolean bl = reset = decoration == null && input2.equals("reset");
            if (color2 == null && decoration == null && !reset) {
                throw new JsonParseException("Don't know how to parse " + input2 + " at " + in.getPath());
            }
            return new TextColorWrapper(color2, decoration, reset);
        }
    }
}

