/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util;

import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TriState {
    NOT_SET,
    FALSE,
    TRUE;


    @Nullable
    public Boolean toBoolean() {
        switch (this) {
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean toBooleanOrElse(boolean other) {
        switch (this) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return other;
    }

    public boolean toBooleanOrElseGet(@NotNull BooleanSupplier supplier) {
        switch (this) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return supplier.getAsBoolean();
    }

    @NotNull
    public static TriState byBoolean(boolean value2) {
        return value2 ? TRUE : FALSE;
    }

    @NotNull
    public static TriState byBoolean(@Nullable Boolean value2) {
        return value2 == null ? NOT_SET : TriState.byBoolean((boolean)value2);
    }
}

