/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging;

import io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.Log;
import io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.LogConfigurationException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public abstract class LogFactory {
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.LogFactory";
    private static final String FACTORY_LOG4J_API = "io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.impl.Log4jApiLogFactory";
    private static final String LOG4J_API_LOGGER = "org.apache.logging.log4j.Logger";
    private static final String LOG4J_TO_SLF4J_BRIDGE = "org.apache.logging.slf4j.SLF4JProvider";
    private static final String FACTORY_SLF4J = "io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.impl.Slf4jLogFactory";
    private static final String SLF4J_API_LOGGER = "org.slf4j.Logger";
    public static final String FACTORY_DEFAULT = "io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.diagnostics.dest";
    private static final PrintStream DIAGNOSTICS_STREAM;
    private static final String diagnosticPrefix;
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.LogFactory.HashtableImpl";
    private static final String WEAK_HASHTABLE_CLASSNAME = "io.github.quiltservertools.blockbotdiscord.libs.org.apache.commons.logging.impl.WeakHashtable";
    private static final WeakReference<ClassLoader> thisClassLoaderRef;
    private static final int MAX_BROKEN_SERVICES = 3;
    protected static Hashtable<ClassLoader, LogFactory> factories;
    @Deprecated
    protected static volatile LogFactory nullClassLoaderFactory;

    private static void cacheFactory(ClassLoader classLoader, LogFactory factory2) {
        if (factory2 != null) {
            if (classLoader == null) {
                nullClassLoaderFactory = factory2;
            } else {
                factories.put(classLoader, factory2);
            }
        }
    }

    protected static Object createFactory(String factoryClassName, ClassLoader classLoader) {
        Class<?> logFactoryClass = null;
        try {
            block21: {
                if (classLoader != null) {
                    try {
                        logFactoryClass = classLoader.loadClass(factoryClassName);
                        if (LogFactory.class.isAssignableFrom(logFactoryClass)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Loaded class " + logFactoryClass.getName() + " from class loader " + LogFactory.objectId(classLoader));
                            }
                        } else if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("Factory class " + logFactoryClass.getName() + " loaded from class loader " + LogFactory.objectId(logFactoryClass.getClassLoader()) + " does not extend '" + LogFactory.class.getName() + "' as loaded by this class loader.");
                            LogFactory.logHierarchy("[BAD CL TREE] ", classLoader);
                        }
                        return logFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException ex) {
                        if (classLoader == thisClassLoaderRef.get()) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Unable to locate any class called '" + factoryClassName + "' via class loader " + LogFactory.objectId(classLoader));
                            }
                            throw ex;
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        if (classLoader == thisClassLoaderRef.get()) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Class '" + factoryClassName + "' cannot be loaded via class loader " + LogFactory.objectId(classLoader) + " - it depends on some other class that cannot be found.");
                            }
                            throw e;
                        }
                    }
                    catch (ClassCastException e) {
                        if (classLoader != thisClassLoaderRef.get()) break block21;
                        boolean implementsLogFactory = LogFactory.implementsLogFactory(logFactoryClass);
                        StringBuilder msg = new StringBuilder();
                        msg.append("The application has specified that a custom LogFactory implementation ");
                        msg.append("should be used but Class '");
                        msg.append(factoryClassName);
                        msg.append("' cannot be converted to '");
                        msg.append(LogFactory.class.getName());
                        msg.append("'. ");
                        if (implementsLogFactory) {
                            msg.append("The conflict is caused by the presence of multiple LogFactory classes ");
                            msg.append("in incompatible class loaders. ");
                            msg.append("Background can be found in https://commons.apache.org/logging/tech.html. ");
                            msg.append("If you have not explicitly specified a custom LogFactory then it is likely ");
                            msg.append("that the container has set one without your knowledge. ");
                            msg.append("In this case, consider using the commons-logging-adapters.jar file or ");
                            msg.append("specifying the standard LogFactory from the command line. ");
                        } else {
                            msg.append("Please check the custom implementation. ");
                        }
                        msg.append("Help can be found at https://commons.apache.org/logging/troubleshooting.html.");
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic(msg.toString());
                        }
                        throw new ClassCastException(msg.toString());
                    }
                }
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to load factory class via class loader " + LogFactory.objectId(classLoader) + " - trying the class loader associated with this LogFactory.");
            }
            logFactoryClass = Class.forName(factoryClassName);
            return logFactoryClass.newInstance();
        }
        catch (Exception e) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to create LogFactory instance.");
            }
            if (logFactoryClass != null && !LogFactory.class.isAssignableFrom(logFactoryClass)) {
                return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", e);
            }
            return new LogConfigurationException(e);
        }
    }

    private static Hashtable<ClassLoader, LogFactory> createFactoryStore() {
        Hashtable result2;
        block7: {
            String storeImplementationClass;
            result2 = null;
            try {
                storeImplementationClass = LogFactory.getSystemProperty(HASHTABLE_IMPLEMENTATION_PROPERTY, null);
            }
            catch (SecurityException ex) {
                storeImplementationClass = null;
            }
            if (storeImplementationClass == null) {
                storeImplementationClass = WEAK_HASHTABLE_CLASSNAME;
            }
            try {
                Class<?> implementationClass = Class.forName(storeImplementationClass);
                result2 = (Hashtable)implementationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                LogFactory.handleThrowable(t);
                if (WEAK_HASHTABLE_CLASSNAME.equals(storeImplementationClass)) break block7;
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[ERROR] LogFactory: Load of custom Hashtable failed");
                }
                System.err.println("[ERROR] LogFactory: Load of custom Hashtable failed");
            }
        }
        if (result2 == null) {
            result2 = new Hashtable();
        }
        return result2;
    }

    protected static ClassLoader directGetContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(ClassLoader contextClassLoader) {
        if (contextClassLoader == null) {
            return nullClassLoaderFactory;
        }
        return factories.get(contextClassLoader);
    }

    protected static ClassLoader getClassLoader(Class<?> clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException ex) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to get class loader for class '" + clazz + "' due to security restrictions - " + ex.getMessage());
            }
            throw ex;
        }
    }

    private static Properties getConfigurationFile(ClassLoader classLoader, String fileName) {
        URL propsUrl;
        Properties props;
        block12: {
            props = null;
            double priority = 0.0;
            propsUrl = null;
            try {
                Enumeration<URL> urls2 = LogFactory.getResources(classLoader, fileName);
                if (urls2 == null) {
                    return null;
                }
                while (urls2.hasMoreElements()) {
                    URL url2 = urls2.nextElement();
                    Properties newProps = LogFactory.getProperties(url2);
                    if (newProps == null) continue;
                    if (props == null) {
                        propsUrl = url2;
                        props = newProps;
                        String priorityStr = props.getProperty(PRIORITY_KEY);
                        priority = 0.0;
                        if (priorityStr != null) {
                            priority = Double.parseDouble(priorityStr);
                        }
                        if (!LogFactory.isDiagnosticsEnabled()) continue;
                        LogFactory.logDiagnostic("[LOOKUP] Properties file found at '" + url2 + "' with priority " + priority);
                        continue;
                    }
                    String newPriorityStr = newProps.getProperty(PRIORITY_KEY);
                    double newPriority = 0.0;
                    if (newPriorityStr != null) {
                        newPriority = Double.parseDouble(newPriorityStr);
                    }
                    if (newPriority > priority) {
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + url2 + "' with priority " + newPriority + " overrides file at '" + propsUrl + "' with priority " + priority);
                        }
                        propsUrl = url2;
                        props = newProps;
                        priority = newPriority;
                        continue;
                    }
                    if (!LogFactory.isDiagnosticsEnabled()) continue;
                    LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + url2 + "' with priority " + newPriority + " does not override file at '" + propsUrl + "' with priority " + priority);
                }
            }
            catch (SecurityException e) {
                if (!LogFactory.isDiagnosticsEnabled()) break block12;
                LogFactory.logDiagnostic("SecurityException thrown while trying to find/read config files.");
            }
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            if (props == null) {
                LogFactory.logDiagnostic("[LOOKUP] No properties file of name '" + fileName + "' found.");
            } else {
                LogFactory.logDiagnostic("[LOOKUP] Properties file of name '" + fileName + "' found at '" + propsUrl + '\"');
            }
        }
        return props;
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.directGetContextClassLoader();
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return AccessController.doPrivileged(LogFactory::directGetContextClassLoader);
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        String factoryClass;
        ClassLoader baseClassLoader;
        Properties props;
        LogFactory factory2;
        ClassLoader contextClassLoader;
        block41: {
            String useTCCLStr;
            contextClassLoader = LogFactory.getContextClassLoaderInternal();
            if (contextClassLoader == null && LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Context class loader is null.");
            }
            if ((factory2 = LogFactory.getCachedFactory(contextClassLoader)) != null) {
                return factory2;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] LogFactory implementation requested for the first time for context class loader " + LogFactory.objectId(contextClassLoader));
                LogFactory.logHierarchy("[LOOKUP] ", contextClassLoader);
            }
            props = LogFactory.getConfigurationFile(contextClassLoader, FACTORY_PROPERTIES);
            baseClassLoader = contextClassLoader;
            if (props != null && (useTCCLStr = props.getProperty(TCCL_KEY)) != null && !Boolean.parseBoolean(useTCCLStr)) {
                baseClassLoader = (ClassLoader)thisClassLoaderRef.get();
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] Looking for system property [org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
            }
            try {
                factoryClass = LogFactory.getSystemProperty(FACTORY_PROPERTY, null);
                if (factoryClass != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] Creating an instance of LogFactory class '" + factoryClass + "' as specified by system property " + FACTORY_PROPERTY);
                    }
                    factory2 = LogFactory.newFactory(factoryClass, baseClassLoader, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] No system property [org.apache.commons.logging.LogFactory] defined.");
                }
            }
            catch (SecurityException e) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(e.getMessage()) + "]. Trying alternative implementations...");
                }
            }
            catch (RuntimeException e) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] An exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(e.getMessage()) + "] as specified by a system property.");
                }
                throw e;
            }
            if (factory2 == null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Using ServiceLoader  to define the LogFactory subclass to use...");
                }
                try {
                    ServiceLoader<LogFactory> serviceLoader = ServiceLoader.load(LogFactory.class);
                    Iterator<LogFactory> iterator2 = serviceLoader.iterator();
                    int i = 3;
                    while (factory2 == null && i-- > 0) {
                        try {
                            if (!iterator2.hasNext()) continue;
                            factory2 = iterator2.next();
                        }
                        catch (LinkageError | ServiceConfigurationError ex) {
                            if (!LogFactory.isDiagnosticsEnabled()) continue;
                            LogFactory.logDiagnostic("[LOOKUP] An exception occurred while trying to find an instance of LogFactory: [" + LogFactory.trim(ex.getMessage()) + "]. Trying alternative implementations...");
                        }
                    }
                }
                catch (Exception ex) {
                    if (!LogFactory.isDiagnosticsEnabled()) break block41;
                    LogFactory.logDiagnostic("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(ex.getMessage()) + "]. Trying alternative implementations...");
                }
            }
        }
        if (factory2 == null) {
            if (props != null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Looking in properties file for entry with key 'org.apache.commons.logging.LogFactory' to define the LogFactory subclass to use...");
                }
                if ((factoryClass = props.getProperty(FACTORY_PROPERTY)) != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] Properties file specifies LogFactory subclass '" + factoryClass + "'");
                    }
                    factory2 = LogFactory.newFactory(factoryClass, baseClassLoader, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Properties file has no entry specifying LogFactory subclass.");
                }
            } else if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] No properties file available to determine LogFactory subclass from..");
            }
        }
        try {
            if (factory2 == null && LogFactory.isClassAvailable(LOG4J_API_LOGGER, baseClassLoader)) {
                if (LogFactory.isClassAvailable(LOG4J_TO_SLF4J_BRIDGE, baseClassLoader)) {
                    LogFactory.logDiagnostic("[LOOKUP] Log4j API to SLF4J redirection detected. Loading the SLF4J LogFactory implementation 'org.apache.commons.logging.impl.Slf4jLogFactory'.");
                    factory2 = LogFactory.newFactory(FACTORY_SLF4J, baseClassLoader, contextClassLoader);
                } else {
                    LogFactory.logDiagnostic("[LOOKUP] Log4j API detected. Loading the Log4j API LogFactory implementation 'org.apache.commons.logging.impl.Log4jApiLogFactory'.");
                    factory2 = LogFactory.newFactory(FACTORY_LOG4J_API, baseClassLoader, contextClassLoader);
                }
            }
            if (factory2 == null && LogFactory.isClassAvailable(SLF4J_API_LOGGER, baseClassLoader)) {
                LogFactory.logDiagnostic("[LOOKUP] SLF4J detected. Loading the SLF4J LogFactory implementation 'org.apache.commons.logging.impl.Slf4jLogFactory'.");
                factory2 = LogFactory.newFactory(FACTORY_SLF4J, baseClassLoader, contextClassLoader);
            }
        }
        catch (Exception e) {
            LogFactory.logDiagnostic("[LOOKUP] An exception occurred while creating LogFactory: " + e.getMessage());
        }
        if (factory2 == null) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] Loading the default LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl' via the same class loader that loaded this LogFactory class (ie not looking in the context class loader).");
            }
            factory2 = LogFactory.newFactory(FACTORY_DEFAULT, (ClassLoader)thisClassLoaderRef.get(), contextClassLoader);
        }
        if (factory2 != null) {
            LogFactory.cacheFactory(contextClassLoader, factory2);
            if (props != null) {
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name2 = Objects.toString(names.nextElement(), null);
                    String value2 = props.getProperty(name2);
                    factory2.setAttribute(name2, value2);
                }
            }
        }
        return factory2;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name2) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name2);
    }

    private static Properties getProperties(URL url2) {
        return AccessController.doPrivileged(() -> {
            try {
                URLConnection connection = url2.openConnection();
                connection.setUseCaches(false);
                try (InputStream stream = connection.getInputStream();){
                    if (stream == null) return null;
                    Properties props = new Properties();
                    props.load(stream);
                    Properties properties = props;
                    return properties;
                }
                catch (IOException e) {
                    if (!LogFactory.isDiagnosticsEnabled()) return null;
                    LogFactory.logDiagnostic("Unable to close stream for URL " + url2);
                    return null;
                }
            }
            catch (IOException e) {
                if (!LogFactory.isDiagnosticsEnabled()) return null;
                LogFactory.logDiagnostic("Unable to read URL " + url2);
            }
            return null;
        });
    }

    private static Enumeration<URL> getResources(ClassLoader loader, String name2) {
        return AccessController.doPrivileged(() -> {
            try {
                if (loader != null) {
                    return loader.getResources(name2);
                }
                return ClassLoader.getSystemResources(name2);
            }
            catch (IOException e) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("Exception while trying to find configuration file " + name2 + ":" + e.getMessage());
                }
                return null;
            }
            catch (NoSuchMethodError e) {
                return null;
            }
        });
    }

    private static String getSystemProperty(String key, String def2) throws SecurityException {
        return AccessController.doPrivileged(() -> System.getProperty(key, def2));
    }

    protected static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }

    private static boolean implementsLogFactory(Class<?> logFactoryClass) {
        boolean implementsLogFactory = false;
        if (logFactoryClass != null) {
            try {
                ClassLoader logFactoryClassLoader = logFactoryClass.getClassLoader();
                if (logFactoryClassLoader == null) {
                    LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] was loaded by the boot class loader");
                } else {
                    LogFactory.logHierarchy("[CUSTOM LOG FACTORY] ", logFactoryClassLoader);
                    Class<?> factoryFromCustomLoader = Class.forName(FACTORY_PROPERTY, false, logFactoryClassLoader);
                    implementsLogFactory = factoryFromCustomLoader.isAssignableFrom(logFactoryClass);
                    String logFactoryClassName = logFactoryClass.getName();
                    if (implementsLogFactory) {
                        LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] " + logFactoryClassName + " implements LogFactory but was loaded by an incompatible class loader.");
                    } else {
                        LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] " + logFactoryClassName + " does not implement LogFactory.");
                    }
                }
            }
            catch (SecurityException e) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] SecurityException caught trying to determine whether the compatibility was caused by a class loader conflict: " + e.getMessage());
            }
            catch (LinkageError e) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] LinkageError caught trying to determine whether the compatibility was caused by a class loader conflict: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] LogFactory class cannot be loaded by the class loader which loaded the custom LogFactory implementation. Is the custom factory in the right class loader?");
            }
        }
        return implementsLogFactory;
    }

    private static PrintStream initDiagnostics() {
        String dest;
        try {
            dest = LogFactory.getSystemProperty(DIAGNOSTICS_DEST_PROPERTY, null);
            if (dest == null) {
                return null;
            }
        }
        catch (SecurityException ex) {
            return null;
        }
        if (dest.equals("STDOUT")) {
            return System.out;
        }
        if (dest.equals("STDERR")) {
            return System.err;
        }
        try {
            FileOutputStream fos = new FileOutputStream(dest, true);
            return new PrintStream((OutputStream)fos, false, StandardCharsets.UTF_8.name());
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static boolean isClassAvailable(String className, ClassLoader classLoader) {
        ClassLoader loader = LogFactory.class.getClassLoader();
        LogFactory.logDiagnostic("Checking if class '" + className + "' is available in class loader " + LogFactory.objectId(loader));
        try {
            Class.forName(className, true, classLoader);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            LogFactory.logDiagnostic("Failed to load class '" + className + "' from class loader " + LogFactory.objectId(loader) + ": " + e.getMessage());
            return false;
        }
    }

    protected static boolean isDiagnosticsEnabled() {
        return DIAGNOSTICS_STREAM != null;
    }

    private static void logClassLoaderEnvironment(Class<?> clazz) {
        ClassLoader classLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        try {
            LogFactory.logDiagnostic("[ENV] Extension directories (java.ext.dir): " + System.getProperty("java.ext.dir"));
            LogFactory.logDiagnostic("[ENV] Application classpath (java.class.path): " + System.getProperty("java.class.path"));
        }
        catch (SecurityException ex) {
            LogFactory.logDiagnostic("[ENV] Security setting prevent interrogation of system classpaths.");
        }
        String className = clazz.getName();
        try {
            classLoader = LogFactory.getClassLoader(clazz);
        }
        catch (SecurityException ex) {
            LogFactory.logDiagnostic("[ENV] Security forbids determining the class loader for " + className);
            return;
        }
        LogFactory.logDiagnostic("[ENV] Class " + className + " was loaded via class loader " + LogFactory.objectId(classLoader));
        LogFactory.logHierarchy("[ENV] Ancestry of class loader which loaded " + className + " is ", classLoader);
    }

    private static void logDiagnostic(String msg) {
        if (DIAGNOSTICS_STREAM != null) {
            DIAGNOSTICS_STREAM.print(diagnosticPrefix);
            DIAGNOSTICS_STREAM.println(msg);
            DIAGNOSTICS_STREAM.flush();
        }
    }

    private static void logHierarchy(String prefix2, ClassLoader classLoader) {
        ClassLoader systemClassLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        if (classLoader != null) {
            String classLoaderString = classLoader.toString();
            LogFactory.logDiagnostic(prefix2 + LogFactory.objectId(classLoader) + " == '" + classLoaderString + "'");
        }
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException ex) {
            LogFactory.logDiagnostic(prefix2 + "Security forbids determining the system class loader.");
            return;
        }
        if (classLoader != null) {
            StringBuilder buf;
            block9: {
                buf = new StringBuilder(prefix2 + "ClassLoader tree:");
                do {
                    buf.append(LogFactory.objectId(classLoader));
                    if (classLoader == systemClassLoader) {
                        buf.append(" (SYSTEM) ");
                    }
                    try {
                        classLoader = classLoader.getParent();
                    }
                    catch (SecurityException ex) {
                        buf.append(" --> SECRET");
                        break block9;
                    }
                    buf.append(" --> ");
                } while (classLoader != null);
                buf.append("BOOT");
            }
            LogFactory.logDiagnostic(buf.toString());
        }
    }

    protected static final void logRawDiagnostic(String msg) {
        if (DIAGNOSTICS_STREAM != null) {
            DIAGNOSTICS_STREAM.println(msg);
            DIAGNOSTICS_STREAM.flush();
        }
    }

    protected static LogFactory newFactory(String factoryClass, ClassLoader classLoader) {
        return LogFactory.newFactory(factoryClass, classLoader, null);
    }

    protected static LogFactory newFactory(String factoryClass, ClassLoader classLoader, ClassLoader contextClassLoader) throws LogConfigurationException {
        Object result2 = AccessController.doPrivileged(() -> LogFactory.createFactory(factoryClass, classLoader));
        if (result2 instanceof LogConfigurationException) {
            LogConfigurationException ex = (LogConfigurationException)result2;
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("An error occurred while loading the factory class:" + ex.getMessage());
            }
            throw ex;
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Created object " + LogFactory.objectId(result2) + " to manage class loader " + LogFactory.objectId(contextClassLoader));
        }
        return (LogFactory)result2;
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ClassLoader classLoader) {
        Hashtable<ClassLoader, LogFactory> factories;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Releasing factory for class loader " + LogFactory.objectId(classLoader));
        }
        Hashtable<ClassLoader, LogFactory> hashtable = factories = LogFactory.factories;
        synchronized (hashtable) {
            if (classLoader == null) {
                if (nullClassLoaderFactory != null) {
                    nullClassLoaderFactory.release();
                    nullClassLoaderFactory = null;
                }
            } else {
                LogFactory factory2 = factories.get(classLoader);
                if (factory2 != null) {
                    factory2.release();
                    factories.remove(classLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Hashtable<ClassLoader, LogFactory> factories;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Releasing factory for all class loaders.");
        }
        Hashtable<ClassLoader, LogFactory> hashtable = factories = LogFactory.factories;
        synchronized (hashtable) {
            factories.values().forEach(LogFactory::release);
            factories.clear();
            if (nullClassLoaderFactory != null) {
                nullClassLoaderFactory.release();
                nullClassLoaderFactory = null;
            }
        }
    }

    private static String trim(String src) {
        if (src == null) {
            return null;
        }
        return src.trim();
    }

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class<?> var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    static {
        String classLoaderName;
        ClassLoader thisClassLoader = LogFactory.getClassLoader(LogFactory.class);
        thisClassLoaderRef = new WeakReference<ClassLoader>(thisClassLoader);
        try {
            classLoaderName = thisClassLoader == null ? "BOOTLOADER" : LogFactory.objectId(thisClassLoader);
        }
        catch (SecurityException e) {
            classLoaderName = "UNKNOWN";
        }
        diagnosticPrefix = "[LogFactory from " + classLoaderName + "] ";
        DIAGNOSTICS_STREAM = LogFactory.initDiagnostics();
        LogFactory.logClassLoaderEnvironment(LogFactory.class);
        factories = LogFactory.createFactoryStore();
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("BOOTSTRAP COMPLETED");
        }
    }
}

