/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.pf4j;

import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.Extension;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.ExtensionDescriptor;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.ExtensionFinder;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.ExtensionWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.PluginDependency;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.PluginManager;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.PluginStateEvent;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.PluginStateListener;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.PluginWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.asm.ExtensionInfo;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtensionFinder
implements ExtensionFinder,
PluginStateListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractExtensionFinder.class);
    protected PluginManager pluginManager;
    protected volatile Map<String, Set<String>> entries;
    protected volatile Map<String, ExtensionInfo> extensionInfos;
    protected Boolean checkForExtensionDependencies = null;

    protected AbstractExtensionFinder(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public abstract Map<String, Set<String>> readPluginsStorages();

    public abstract Map<String, Set<String>> readClasspathStorages();

    @Override
    public <T> List<ExtensionWrapper<T>> find(Class<T> type) {
        log.debug("Finding extensions of extension point '{}'", (Object)type.getName());
        Map<String, Set<String>> entries2 = this.getEntries();
        ArrayList<ExtensionWrapper<T>> result2 = new ArrayList<ExtensionWrapper<T>>();
        for (String pluginId : entries2.keySet()) {
            List<ExtensionWrapper<T>> pluginExtensions = this.find(type, pluginId);
            result2.addAll(pluginExtensions);
        }
        if (result2.isEmpty()) {
            log.debug("No extensions found for extension point '{}'", (Object)type.getName());
        } else {
            log.debug("Found {} extensions for extension point '{}'", (Object)result2.size(), (Object)type.getName());
        }
        Collections.sort(result2);
        return result2;
    }

    @Override
    public <T> List<ExtensionWrapper<T>> find(Class<T> type, String pluginId) {
        log.debug("Finding extensions of extension point '{}' for plugin '{}'", (Object)type.getName(), (Object)pluginId);
        ArrayList<ExtensionWrapper<T>> result2 = new ArrayList<ExtensionWrapper<T>>();
        Set<String> classNames = this.findClassNames(pluginId);
        if (classNames.isEmpty()) {
            return result2;
        }
        if (pluginId != null) {
            PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
            if (!pluginWrapper.getPluginState().isStarted()) {
                return result2;
            }
            log.trace("Checking extensions from plugin '{}'", (Object)pluginId);
        } else {
            log.trace("Checking extensions from classpath");
        }
        ClassLoader classLoader = pluginId != null ? this.pluginManager.getPluginClassLoader(pluginId) : this.getClass().getClassLoader();
        for (String className : classNames) {
            try {
                if (this.isCheckForExtensionDependencies()) {
                    ExtensionInfo extensionInfo = this.getExtensionInfo(className, classLoader);
                    if (extensionInfo == null) {
                        log.error("No extension annotation was found for '{}'", (Object)className);
                        continue;
                    }
                    ArrayList<String> missingPluginIds = new ArrayList<String>();
                    for (String requiredPluginId : extensionInfo.getPlugins()) {
                        PluginWrapper requiredPlugin = this.pluginManager.getPlugin(requiredPluginId);
                        if (requiredPlugin != null && requiredPlugin.getPluginState().isStarted()) continue;
                        missingPluginIds.add(requiredPluginId);
                    }
                    if (!missingPluginIds.isEmpty()) {
                        StringBuilder missing = new StringBuilder();
                        for (String missingPluginId : missingPluginIds) {
                            if (missing.length() > 0) {
                                missing.append(", ");
                            }
                            missing.append(missingPluginId);
                        }
                        log.trace("Extension '{}' is ignored due to missing plugins: {}", (Object)className, (Object)missing);
                        continue;
                    }
                }
                log.debug("Loading class '{}' using class loader '{}'", (Object)className, (Object)classLoader);
                Class<?> extensionClass = classLoader.loadClass(className);
                log.debug("Checking extension type '{}'", (Object)className);
                if (type.isAssignableFrom(extensionClass)) {
                    ExtensionWrapper extensionWrapper = this.createExtensionWrapper(extensionClass);
                    result2.add(extensionWrapper);
                    log.debug("Added extension '{}' with ordinal {}", (Object)className, (Object)extensionWrapper.getOrdinal());
                    continue;
                }
                log.trace("'{}' is not an extension for extension point '{}'", (Object)className, (Object)type.getName());
                if (!this.checkDifferentClassLoaders(type, extensionClass)) continue;
                log.error("Different class loaders: '{}' (E) and '{}' (EP)", (Object)extensionClass.getClassLoader(), (Object)type.getClassLoader());
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                log.error(e.getMessage(), e);
            }
        }
        if (result2.isEmpty()) {
            log.debug("No extensions found for extension point '{}'", (Object)type.getName());
        } else {
            log.debug("Found {} extensions for extension point '{}'", (Object)result2.size(), (Object)type.getName());
        }
        Collections.sort(result2);
        return result2;
    }

    @Override
    public List<ExtensionWrapper> find(String pluginId) {
        log.debug("Finding extensions from plugin '{}'", (Object)pluginId);
        ArrayList<ExtensionWrapper> result2 = new ArrayList<ExtensionWrapper>();
        Set<String> classNames = this.findClassNames(pluginId);
        if (classNames.isEmpty()) {
            return result2;
        }
        if (pluginId != null) {
            PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
            if (!pluginWrapper.getPluginState().isStarted()) {
                return result2;
            }
            log.trace("Checking extensions from plugin '{}'", (Object)pluginId);
        } else {
            log.trace("Checking extensions from classpath");
        }
        ClassLoader classLoader = pluginId != null ? this.pluginManager.getPluginClassLoader(pluginId) : this.getClass().getClassLoader();
        for (String className : classNames) {
            try {
                log.debug("Loading class '{}' using class loader '{}'", (Object)className, (Object)classLoader);
                Class<?> extensionClass = classLoader.loadClass(className);
                ExtensionWrapper extensionWrapper = this.createExtensionWrapper(extensionClass);
                result2.add(extensionWrapper);
                log.debug("Added extension '{}' with ordinal {}", (Object)className, (Object)extensionWrapper.getOrdinal());
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                log.error(e.getMessage(), e);
            }
        }
        if (result2.isEmpty()) {
            log.debug("No extensions found for plugin '{}'", (Object)pluginId);
        } else {
            log.debug("Found {} extensions for plugin '{}'", (Object)result2.size(), (Object)pluginId);
        }
        Collections.sort(result2);
        return result2;
    }

    @Override
    public Set<String> findClassNames(String pluginId) {
        Set<String> classNames = this.getEntries().get(pluginId);
        if (classNames == null) {
            return Collections.emptySet();
        }
        return classNames;
    }

    @Override
    public void pluginStateChanged(PluginStateEvent event2) {
        this.entries = null;
        if (this.checkForExtensionDependencies == null && event2.getPluginState().isStarted()) {
            for (PluginDependency dependency : event2.getPlugin().getDescriptor().getDependencies()) {
                if (!dependency.isOptional()) continue;
                log.debug("Enable check for extension dependencies via ASM.");
                this.checkForExtensionDependencies = true;
                break;
            }
        }
    }

    public final boolean isCheckForExtensionDependencies() {
        return Boolean.TRUE.equals(this.checkForExtensionDependencies);
    }

    public void setCheckForExtensionDependencies(boolean checkForExtensionDependencies) {
        this.checkForExtensionDependencies = checkForExtensionDependencies;
    }

    protected void debugExtensions(Set<String> extensions) {
        if (log.isDebugEnabled()) {
            if (extensions.isEmpty()) {
                log.debug("No extensions found");
            } else {
                log.debug("Found possible {} extensions:", (Object)extensions.size());
                for (String extension : extensions) {
                    log.debug("   " + extension);
                }
            }
        }
    }

    private Map<String, Set<String>> readStorages() {
        LinkedHashMap<String, Set<String>> result2 = new LinkedHashMap<String, Set<String>>();
        result2.putAll(this.readClasspathStorages());
        result2.putAll(this.readPluginsStorages());
        return result2;
    }

    private Map<String, Set<String>> getEntries() {
        if (this.entries == null) {
            this.entries = this.readStorages();
        }
        return this.entries;
    }

    private ExtensionInfo getExtensionInfo(String className, ClassLoader classLoader) {
        if (this.extensionInfos == null) {
            this.extensionInfos = new HashMap<String, ExtensionInfo>();
        }
        if (!this.extensionInfos.containsKey(className)) {
            log.trace("Load annotation for '{}' using asm", (Object)className);
            ExtensionInfo info2 = ExtensionInfo.load(className, classLoader);
            if (info2 == null) {
                log.warn("No extension annotation was found for '{}'", (Object)className);
                this.extensionInfos.put(className, null);
            } else {
                this.extensionInfos.put(className, info2);
            }
        }
        return this.extensionInfos.get(className);
    }

    private ExtensionWrapper createExtensionWrapper(Class<?> extensionClass) {
        Extension extensionAnnotation = AbstractExtensionFinder.findExtensionAnnotation(extensionClass);
        int ordinal = extensionAnnotation != null ? extensionAnnotation.ordinal() : 0;
        ExtensionDescriptor descriptor2 = new ExtensionDescriptor(ordinal, extensionClass);
        return new ExtensionWrapper(descriptor2, this.pluginManager.getExtensionFactory());
    }

    public static Extension findExtensionAnnotation(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Extension.class)) {
            return clazz.getAnnotation(Extension.class);
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            Extension extensionAnnotation;
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (annotationClass.getName().startsWith("java.lang.annotation") || annotationClass.getName().startsWith("kotlin") || annotationClass.equals(clazz) || (extensionAnnotation = AbstractExtensionFinder.findExtensionAnnotation(annotationClass)) == null) continue;
            return extensionAnnotation;
        }
        return null;
    }

    boolean checkDifferentClassLoaders(Class<?> type, Class<?> extensionClass) {
        ClassLoader typeClassLoader = type.getClassLoader();
        ClassLoader extensionClassLoader = extensionClass.getClassLoader();
        boolean match = ClassUtils.getAllInterfacesNames(extensionClass).contains(type.getSimpleName());
        return match && extensionClassLoader != typeClassLoader;
    }
}

