/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.pf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public enum RuntimeMode {
    DEVELOPMENT("development", "dev"),
    DEPLOYMENT("deployment", "prod");

    private final String name;
    private final String[] aliases;
    private static final Map<String, RuntimeMode> map;

    private RuntimeMode(String name2, String ... aliases) {
        this.name = name2;
        this.aliases = aliases;
    }

    public String toString() {
        return this.name;
    }

    public static RuntimeMode byName(String name2) {
        if (map.containsKey(name2)) {
            return map.get(name2);
        }
        throw new NoSuchElementException("Cannot found PF4J runtime mode with name '" + name2 + "'.Must be one value from '" + map.keySet() + ".");
    }

    static {
        map = new HashMap<String, RuntimeMode>();
        for (RuntimeMode mode2 : RuntimeMode.values()) {
            map.put(mode2.name, mode2);
            for (String alias : mode2.aliases) {
                map.put(alias, mode2);
            }
        }
    }
}

