/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.processor;

import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.processor.ExtensionAnnotationProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;

public abstract class ExtensionStorage {
    private static final Pattern COMMENT = Pattern.compile("#.*");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    protected final ExtensionAnnotationProcessor processor;

    public ExtensionStorage(ExtensionAnnotationProcessor processor) {
        this.processor = processor;
    }

    public abstract Map<String, Set<String>> read();

    public abstract void write(Map<String, Set<String>> var1);

    protected Filer getFiler() {
        return this.processor.getProcessingEnvironment().getFiler();
    }

    protected void error(String message2, Object ... args) {
        this.processor.error(message2, args);
    }

    protected void error(Element element, String message2, Object ... args) {
        this.processor.error(element, message2, args);
    }

    protected void info(String message2, Object ... args) {
        this.processor.info(message2, args);
    }

    protected void info(Element element, String message2, Object ... args) {
        this.processor.info(element, message2, args);
    }

    public static void read(Reader reader2, Set<String> entries2) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader2);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                line = COMMENT.matcher(line).replaceFirst("");
                if ((line = WHITESPACE.matcher(line).replaceAll("")).length() <= 0) continue;
                entries2.add(line);
            }
        }
    }
}

