/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.reflections.scanners;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.CannotCompileException;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.ClassPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.CtBehavior;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.CtClass;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.CtConstructor;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.LoaderClassPath;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.NotFoundException;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.MethodInfo;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.expr.ConstructorCall;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.expr.ExprEditor;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.expr.FieldAccess;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.expr.MethodCall;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.expr.NewExpr;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.ReflectionsException;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.Store;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.scanners.AbstractScanner;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.util.ClasspathHelper;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.util.Utils;

public class MemberUsageScanner
extends AbstractScanner {
    private ClassPool classPool;

    @Override
    public void scan(Object cls, Store store) {
        try {
            CtClass ctClass = this.getClassPool().get(this.getMetadataAdapter().getClassName(cls));
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                this.scanMember(ctConstructor, store);
            }
            for (CtBehavior ctBehavior : ctClass.getDeclaredMethods()) {
                this.scanMember(ctBehavior, store);
            }
            ctClass.detach();
        }
        catch (Exception e) {
            throw new ReflectionsException("Could not scan method usage for " + this.getMetadataAdapter().getClassName(cls), e);
        }
    }

    void scanMember(CtBehavior member2, final Store store) throws CannotCompileException {
        final String key = member2.getDeclaringClass().getName() + "." + member2.getMethodInfo().getName() + "(" + this.parameterNames(member2.getMethodInfo()) + ")";
        member2.instrument(new ExprEditor(){

            @Override
            public void edit(NewExpr e) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(store, e.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.this.parameterNames(e.getConstructor().getMethodInfo()) + ")", e.getLineNumber(), key);
                }
                catch (NotFoundException e1) {
                    throw new ReflectionsException("Could not find new instance usage in " + key, e1);
                }
            }

            @Override
            public void edit(MethodCall m) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(store, m.getMethod().getDeclaringClass().getName() + "." + m.getMethodName() + "(" + MemberUsageScanner.this.parameterNames(m.getMethod().getMethodInfo()) + ")", m.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + m.getClassName() + " in " + key, e);
                }
            }

            @Override
            public void edit(ConstructorCall c) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(store, c.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.this.parameterNames(c.getConstructor().getMethodInfo()) + ")", c.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + c.getClassName() + " in " + key, e);
                }
            }

            @Override
            public void edit(FieldAccess f) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(store, f.getField().getDeclaringClass().getName() + "." + f.getFieldName(), f.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + f.getFieldName() + " in " + key, e);
                }
            }
        });
    }

    private void put(Store store, String key, int lineNumber, String value2) {
        if (this.acceptResult(key)) {
            this.put(store, key, value2 + " #" + lineNumber);
        }
    }

    String parameterNames(MethodInfo info2) {
        return Utils.join(this.getMetadataAdapter().getParameterNames(info2), ", ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getClassPool() {
        if (this.classPool == null) {
            MemberUsageScanner memberUsageScanner = this;
            synchronized (memberUsageScanner) {
                this.classPool = new ClassPool();
                ClassLoader[] classLoaders = this.getConfiguration().getClassLoaders();
                if (classLoaders == null) {
                    classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0]);
                }
                for (ClassLoader classLoader : classLoaders) {
                    this.classPool.appendClassPath(new LoaderClassPath(classLoader));
                }
            }
        }
        return this.classPool;
    }
}

