/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.reflections.serializers;

import io.github.quiltservertools.blockbotdiscord.libs.org.dom4j.Document;
import io.github.quiltservertools.blockbotdiscord.libs.org.dom4j.DocumentException;
import io.github.quiltservertools.blockbotdiscord.libs.org.dom4j.DocumentFactory;
import io.github.quiltservertools.blockbotdiscord.libs.org.dom4j.Element;
import io.github.quiltservertools.blockbotdiscord.libs.org.dom4j.io.OutputFormat;
import io.github.quiltservertools.blockbotdiscord.libs.org.dom4j.io.SAXReader;
import io.github.quiltservertools.blockbotdiscord.libs.org.dom4j.io.XMLWriter;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.Reflections;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.ReflectionsException;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.Store;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.serializers.Serializer;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.util.ConfigurationBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;

public class XmlSerializer
implements Serializer {
    @Override
    public Reflections read(InputStream inputStream2) {
        Reflections reflections;
        try {
            Constructor constructor2 = Reflections.class.getDeclaredConstructor(new Class[0]);
            constructor2.setAccessible(true);
            reflections = (Reflections)constructor2.newInstance(new Object[0]);
        }
        catch (Exception e) {
            reflections = new Reflections(new ConfigurationBuilder());
        }
        try {
            Document document = new SAXReader().read(inputStream2);
            for (Object e1 : document.getRootElement().elements()) {
                Element index = (Element)e1;
                for (Object e2 : index.elements()) {
                    Element entry = (Element)e2;
                    Element key = entry.element("key");
                    Element values2 = entry.element("values");
                    for (Object o3 : values2.elements()) {
                        Element value2 = (Element)o3;
                        reflections.getStore().put(index.getName(), key.getText(), value2.getText());
                    }
                }
            }
        }
        catch (DocumentException e) {
            throw new ReflectionsException("could not read.", e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not read. Make sure relevant dependencies exist on classpath.", e);
        }
        return reflections;
    }

    @Override
    public File save(Reflections reflections, String filename2) {
        File file2 = Utils.prepareFile(filename2);
        try {
            Document document = this.createDocument(reflections);
            XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(file2), OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new ReflectionsException("could not save to file " + filename2, e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not save to file " + filename2 + ". Make sure relevant dependencies exist on classpath.", e);
        }
        return file2;
    }

    @Override
    public String toString(Reflections reflections) {
        Document document = this.createDocument(reflections);
        try {
            StringWriter writer2 = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer2, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
            return writer2.toString();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private Document createDocument(Reflections reflections) {
        Store map2 = reflections.getStore();
        Document document = DocumentFactory.getInstance().createDocument();
        Element root = document.addElement("Reflections");
        for (String indexName : map2.keySet()) {
            Element indexElement = root.addElement(indexName);
            for (String key : map2.keys(indexName)) {
                Element entryElement = indexElement.addElement("entry");
                entryElement.addElement("key").setText(key);
                Element valuesElement = entryElement.addElement("values");
                for (String value2 : map2.get(indexName, key)) {
                    valuesElement.addElement("value").setText(value2);
                }
            }
        }
        return document;
    }
}

