/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.Mover;
import kotlinx.io.files.NioMover;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.io.files.PathsKt;
import kotlinx.io.files.SystemFileSystemImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u001b\u0010\u0005\u001a\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0001\u0010\u0002\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\"\u0014\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\"\u001a\u0010\r\u001a\u00020\f8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\r\u0010\u000f*\n\u0010\u0011\"\u00020\u00102\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lkotlinx/io/files/Mover;", "mover$delegate", "Lkotlin/Lazy;", "getMover", "()Lkotlinx/io/files/Mover;", "mover", "Lkotlinx/io/files/FileSystem;", "SystemFileSystem", "Lkotlinx/io/files/FileSystem;", "Lkotlinx/io/files/Path;", "SystemTemporaryDirectory", "Lkotlinx/io/files/Path;", "", "isWindows", "Z", "()Z", "Ljava/io/FileNotFoundException;", "FileNotFoundException", "kotlinx-io-core"})
public final class FileSystemJvmKt {
    @NotNull
    private static final Lazy mover$delegate = LazyKt.lazy(FileSystemJvmKt::mover_delegate$lambda$0);
    @JvmField
    @NotNull
    public static final FileSystem SystemFileSystem = new SystemFileSystemImpl(){

        public boolean exists(Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return path.getFile$kotlinx_io_core().exists();
        }

        public void delete(Path path, boolean mustExist) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!this.exists(path)) {
                if (mustExist) {
                    throw new FileNotFoundException("File does not exist: " + path.getFile$kotlinx_io_core());
                }
                return;
            }
            if (!path.getFile$kotlinx_io_core().delete()) {
                throw new IOException("Deletion failed");
            }
        }

        public void createDirectories(Path path, boolean mustCreate) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().mkdirs()) {
                if (mustCreate) {
                    throw new IOException("Path already exist: " + path);
                }
                if (path.getFile$kotlinx_io_core().isFile()) {
                    throw new IOException("Path already exists and it's a file: " + path);
                }
            }
        }

        public void atomicMove(Path source2, Path destination) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            FileSystemJvmKt.access$getMover().move(source2, destination);
        }

        public FileMetadata metadataOrNull(Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().exists()) {
                return null;
            }
            return new FileMetadata(path.getFile$kotlinx_io_core().isFile(), path.getFile$kotlinx_io_core().isDirectory(), path.getFile$kotlinx_io_core().isFile() ? path.getFile$kotlinx_io_core().length() : -1L);
        }

        public RawSource source(Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return JvmCoreKt.asSource(new FileInputStream(path.getFile$kotlinx_io_core()));
        }

        public RawSink sink(Path path, boolean append2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return JvmCoreKt.asSink(new FileOutputStream(path.getFile$kotlinx_io_core(), append2));
        }

        public Path resolve(Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().exists()) {
                throw new FileNotFoundException(path.getFile$kotlinx_io_core().getAbsolutePath());
            }
            File file2 = path.getFile$kotlinx_io_core().getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getCanonicalFile(...)");
            return new Path(file2);
        }

        public Collection<Path> list(Path directory) {
            List list2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                File file2 = directory.getFile$kotlinx_io_core();
                if (!file2.exists()) {
                    throw new FileNotFoundException(file2.getAbsolutePath());
                }
                if (!file2.isDirectory()) {
                    throw new IOException("Not a directory: " + file2.getAbsolutePath());
                }
                List $this$list_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                String[] stringArray = file2.list();
                if (stringArray == null) break block3;
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String childName = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    String[] stringArray2 = new String[]{childName};
                    $this$list_u24lambda_u241.add(PathsKt.Path(directory, stringArray2));
                }
            }
            return CollectionsKt.build((List)list2);
        }
    };
    @JvmField
    @NotNull
    public static final Path SystemTemporaryDirectory;
    private static final boolean isWindows;

    private static final Mover getMover() {
        Lazy lazy2 = mover$delegate;
        return (Mover)lazy2.getValue();
    }

    public static final boolean isWindows() {
        return isWindows;
    }

    private static final Mover mover_delegate$lambda$0() {
        Mover mover2;
        try {
            Class.forName("java.nio.file.Files");
            mover2 = new NioMover();
        }
        catch (ClassNotFoundException e) {
            mover2 = new Mover(){

                public void move(Path source2, Path destination) {
                    Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                    throw new UnsupportedOperationException("Atomic move not supported");
                }
            };
        }
        return mover2;
    }

    public static final /* synthetic */ Mover access$getMover() {
        return FileSystemJvmKt.getMover();
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        SystemTemporaryDirectory = PathsJvmKt.Path(string);
        String string2 = System.getProperty("os.name");
        isWindows = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"Windows", (boolean)false, (int)2, null) : false;
    }
}

