/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\b\u0005*\u0001x\u0018\u00002\u00020\u0001:\u0002z{B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0012\u001a\u00028\u0000\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u001d\u0010$\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0006\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010,\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010.\u001a\u00020&H\u0000\u00a2\u0006\u0004\b-\u0010(J\u0017\u00104\u001a\u0002012\u0006\u00100\u001a\u00020/H\u0000\u00a2\u0006\u0004\b2\u00103J\u000f\u00105\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b7\u00106J;\u0010=\u001a\u00028\u0000\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u000f2\u0006\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b;\u0010<J\u001b\u0010?\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0004\b>\u0010\u0013J\u000f\u0010C\u001a\u00020@H\u0000\u00a2\u0006\u0004\bA\u0010BJ\u0011\u0010G\u001a\u0004\u0018\u00010DH\u0000\u00a2\u0006\u0004\bE\u0010FJ\u000f\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\"\u0010HJ\r\u0010I\u001a\u00020\u0006\u00a2\u0006\u0004\bI\u00106J\u000f\u0010K\u001a\u00020JH\u0016\u00a2\u0006\u0004\bK\u0010LJ\r\u0010M\u001a\u00020\f\u00a2\u0006\u0004\bM\u0010\u0015J#\u0010O\u001a\u00028\u0000\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u000f2\u0006\u0010N\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\bO\u0010\u0013J\u000f\u0010P\u001a\u00020@H\u0002\u00a2\u0006\u0004\bP\u0010BR\u0018\u0010R\u001a\u0004\u0018\u00010Q8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u0016\u0010T\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010UR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010V\u001a\u0004\bW\u0010XR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010Y\u001a\u0004\u0018\u00010\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000b\u0010Z\u001a\u0004\b[\u0010\\R\u0014\u0010^\u001a\u00020]8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b^\u0010_R$\u0010`\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b`\u0010Z\u001a\u0004\ba\u0010\\\"\u0004\bb\u0010\u000eR\u001a\u0010d\u001a\u00020c8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bd\u0010e\u001a\u0004\bf\u0010gR\u0018\u00108\u001a\u0004\u0018\u0001018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u0010hR\u0018\u0010j\u001a\u0004\u0018\u00010i8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bj\u0010kR\u0014\u0010m\u001a\u00020l8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bm\u0010nR\u0016\u0010o\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bo\u0010UR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010U\u001a\u0004\bp\u00106R(\u0010q\u001a\u0004\u0018\u0001012\b\u0010Y\u001a\u0004\u0018\u0001018\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bq\u0010h\u001a\u0004\br\u0010sR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010t\u001a\u0004\bu\u0010HR\u0016\u0010v\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bv\u0010UR\u0016\u0010w\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010UR\u0014\u0010K\u001a\u00020x8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010yR\u0016\u0010M\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010U\u00a8\u0006|"}, d2={"Lokhttp3/internal/connection/RealCall;", "Lokhttp3/Call;", "Lokhttp3/OkHttpClient;", "client", "Lokhttp3/Request;", "originalRequest", "", "forWebSocket", "<init>", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Z)V", "Lokhttp3/internal/connection/RealConnection;", "connection", "", "acquireConnectionNoEvents", "(Lokhttp3/internal/connection/RealConnection;)V", "Ljava/io/IOException;", "E", "e", "callDone", "(Ljava/io/IOException;)Ljava/io/IOException;", "callStart", "()V", "cancel", "clone", "()Lokhttp3/internal/connection/RealCall;", "Lokhttp3/HttpUrl;", "url", "Lokhttp3/Address;", "createAddress", "(Lokhttp3/HttpUrl;)Lokhttp3/Address;", "Lokhttp3/Callback;", "responseCallback", "enqueue", "(Lokhttp3/Callback;)V", "request", "newExchangeFinder", "enterNetworkInterceptorExchange", "(Lokhttp3/Request;Z)V", "Lokhttp3/Response;", "execute", "()Lokhttp3/Response;", "closeExchange", "exitNetworkInterceptorExchange$okhttp", "(Z)V", "exitNetworkInterceptorExchange", "getResponseWithInterceptorChain$okhttp", "getResponseWithInterceptorChain", "Lokhttp3/internal/http/RealInterceptorChain;", "chain", "Lokhttp3/internal/connection/Exchange;", "initExchange$okhttp", "(Lokhttp3/internal/http/RealInterceptorChain;)Lokhttp3/internal/connection/Exchange;", "initExchange", "isCanceled", "()Z", "isExecuted", "exchange", "requestDone", "responseDone", "messageDone$okhttp", "(Lokhttp3/internal/connection/Exchange;ZZLjava/io/IOException;)Ljava/io/IOException;", "messageDone", "noMoreExchanges$okhttp", "noMoreExchanges", "", "redactedUrl$okhttp", "()Ljava/lang/String;", "redactedUrl", "Ljava/net/Socket;", "releaseConnectionNoEvents$okhttp", "()Ljava/net/Socket;", "releaseConnectionNoEvents", "()Lokhttp3/Request;", "retryAfterFailure", "Lokio/AsyncTimeout;", "timeout", "()Lokio/AsyncTimeout;", "timeoutEarlyExit", "cause", "timeoutExit", "toLoggableString", "", "callStackTrace", "Ljava/lang/Object;", "canceled", "Z", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "<set-?>", "Lokhttp3/internal/connection/RealConnection;", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionToCancel", "getConnectionToCancel", "setConnectionToCancel", "Lokhttp3/EventListener;", "eventListener", "Lokhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "Lokhttp3/internal/connection/Exchange;", "Lokhttp3/internal/connection/ExchangeFinder;", "exchangeFinder", "Lokhttp3/internal/connection/ExchangeFinder;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "expectMoreExchanges", "getForWebSocket", "interceptorScopedExchange", "getInterceptorScopedExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "Lokhttp3/Request;", "getOriginalRequest", "requestBodyOpen", "responseBodyOpen", "okhttp3/internal/connection/RealCall.timeout.1", "Lokhttp3/internal/connection/RealCall$timeout$1;", "AsyncCall", "CallReference", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,551:1\n1#2:552\n608#3,4:553\n615#3,4:557\n615#3,4:561\n608#3,4:565\n350#4,7:569\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n*L\n269#1:553,4\n344#1:557,4\n348#1:561,4\n375#1:565,4\n378#1:569,7\n*E\n"})
public final class RealCall
implements Call {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Request originalRequest;
    private final boolean forWebSocket;
    @NotNull
    private final RealConnectionPool connectionPool;
    @NotNull
    private final EventListener eventListener;
    @NotNull
    private final timeout.1 timeout;
    @NotNull
    private final AtomicBoolean executed;
    @Nullable
    private Object callStackTrace;
    @Nullable
    private ExchangeFinder exchangeFinder;
    @Nullable
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    @Nullable
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    @Nullable
    private volatile Exchange exchange;
    @Nullable
    private volatile RealConnection connectionToCancel;

    /*
     * WARNING - void declaration
     */
    public RealCall(@NotNull OkHttpClient client, @NotNull Request originalRequest, boolean forWebSocket) {
        void $this$timeout_u24lambda_u240;
        AsyncTimeout asyncTimeout;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        this.client = client;
        this.originalRequest = originalRequest;
        this.forWebSocket = forWebSocket;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        AsyncTimeout asyncTimeout2 = asyncTimeout = new AsyncTimeout(this){
            final /* synthetic */ RealCall this$0;
            {
                this.this$0 = $receiver;
            }

            protected void timedOut() {
                this.this$0.cancel();
            }
        };
        RealCall realCall = this;
        boolean bl = false;
        $this$timeout_u24lambda_u240.timeout(this.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        realCall.timeout = asyncTimeout;
        this.executed = new AtomicBoolean();
        this.expectMoreExchanges = true;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    @NotNull
    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    @Nullable
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    @Nullable
    public final RealConnection getConnectionToCancel() {
        return this.connectionToCancel;
    }

    public final void setConnectionToCancel(@Nullable RealConnection realConnection) {
        this.connectionToCancel = realConnection;
    }

    @Override
    @NotNull
    public AsyncTimeout timeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public RealCall clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    @Override
    @NotNull
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Exchange exchange = this.exchange;
        if (exchange != null) {
            exchange.cancel();
        }
        RealConnection realConnection = this.connectionToCancel;
        if (realConnection != null) {
            realConnection.cancel();
        }
        this.eventListener.canceled(this);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response execute() {
        if (!this.executed.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.timeout.enter();
        this.callStart();
        try {
            this.client.dispatcher().executed$okhttp(this);
            Response response2 = this.getResponseWithInterceptorChain$okhttp();
            return response2;
        }
        finally {
            this.client.dispatcher().finished$okhttp(this);
        }
    }

    @Override
    public void enqueue(@NotNull Callback responseCallback) {
        Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
        if (!this.executed.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.callStart();
        this.client.dispatcher().enqueue$okhttp(new AsyncCall(responseCallback));
    }

    @Override
    public boolean isExecuted() {
        return this.executed.get();
    }

    private final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response getResponseWithInterceptorChain$okhttp() throws IOException {
        Response response2;
        List interceptors = new ArrayList();
        CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.interceptors());
        ((Collection)interceptors).add(new RetryAndFollowUpInterceptor(this.client));
        ((Collection)interceptors).add(new BridgeInterceptor(this.client.cookieJar()));
        ((Collection)interceptors).add(new CacheInterceptor(this.client.cache()));
        ((Collection)interceptors).add(ConnectInterceptor.INSTANCE);
        if (!this.forWebSocket) {
            CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.networkInterceptors());
        }
        ((Collection)interceptors).add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain chain = new RealInterceptorChain(this, interceptors, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            Response response3 = chain.proceed(this.originalRequest);
            if (this.isCanceled()) {
                Util.closeQuietly(response3);
                throw new IOException("Canceled");
            }
            response2 = response3;
        }
        catch (IOException e) {
            try {
                calledNoMoreExchanges = true;
                IOException iOException = this.noMoreExchanges$okhttp(e);
                Intrinsics.checkNotNull((Object)iOException, (String)"null cannot be cast to non-null type kotlin.Throwable");
                throw (Throwable)iOException;
            }
            catch (Throwable throwable) {
                if (!calledNoMoreExchanges) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        this.noMoreExchanges$okhttp(null);
        return response2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterNetworkInterceptorExchange(@NotNull Request request, boolean newExchangeFinder) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(this.interceptorScopedExchange == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (!(!this.responseBodyOpen)) {
                boolean bl2 = false;
                String string = "cannot make a new request because the previous response is still open: please call response.close()";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (newExchangeFinder) {
            this.exchangeFinder = new ExchangeFinder(this.connectionPool, this.createAddress(request.url()), this, this.eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Exchange initExchange$okhttp(@NotNull RealInterceptorChain chain) {
        Exchange result2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealCall realCall = this;
        synchronized (realCall) {
            boolean $i$a$-synchronized-RealCall$initExchange$32 = false;
            if (!this.expectMoreExchanges) {
                boolean $i$a$-check-RealCall$initExchange$1$22 = false;
                String $i$a$-check-RealCall$initExchange$1$22 = "released";
                throw new IllegalStateException($i$a$-check-RealCall$initExchange$1$22.toString());
            }
            if (!(!this.responseBodyOpen)) {
                String $i$a$-check-RealCall$initExchange$1$22 = "Check failed.";
                throw new IllegalStateException($i$a$-check-RealCall$initExchange$1$22.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String $i$a$-check-RealCall$initExchange$1$22 = "Check failed.";
                throw new IllegalStateException($i$a$-check-RealCall$initExchange$1$22.toString());
            }
            Unit $i$a$-synchronized-RealCall$initExchange$32 = Unit.INSTANCE;
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull((Object)exchangeFinder);
        ExchangeFinder exchangeFinder2 = exchangeFinder;
        ExchangeCodec codec = exchangeFinder2.find(this.client, chain);
        this.interceptorScopedExchange = result2 = new Exchange(this, this.eventListener, exchangeFinder2, codec);
        this.exchange = result2;
        RealCall realCall2 = this;
        synchronized (realCall2) {
            boolean bl = false;
            this.requestBodyOpen = true;
            this.responseBodyOpen = true;
            Unit unit = Unit.INSTANCE;
        }
        if (this.canceled) {
            throw new IOException("Canceled");
        }
        return result2;
    }

    public final void acquireConnectionNoEvents(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        if (!(this.connection == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.connection = connection;
        connection.getCalls().add(new CallReference(this, this.callStackTrace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends IOException> E messageDone$okhttp(@NotNull Exchange exchange, boolean requestDone, boolean responseDone, E e) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (!Intrinsics.areEqual((Object)exchange, (Object)this.exchange)) {
            return e;
        }
        boolean bothStreamsDone = false;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (requestDone && this.requestBodyOpen || responseDone && this.responseBodyOpen) {
                if (requestDone) {
                    this.requestBodyOpen = false;
                }
                if (responseDone) {
                    this.responseBodyOpen = false;
                }
                bothStreamsDone = !this.requestBodyOpen && !this.responseBodyOpen;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen && !this.expectMoreExchanges;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bothStreamsDone) {
            this.exchange = null;
            RealConnection realConnection = this.connection;
            if (realConnection != null) {
                realConnection.incrementSuccessCount$okhttp();
            }
        }
        if (callDone) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IOException noMoreExchanges$okhttp(@Nullable IOException e) {
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (this.expectMoreExchanges) {
                this.expectMoreExchanges = false;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (callDone) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends IOException> E callDone(E e) {
        RealCall $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        RealConnection connection = this.connection;
        if (connection != null) {
            Object object;
            RealConnection $this$assertThreadDoesntHoldLock$iv2 = connection;
            boolean $i$f$assertThreadDoesntHoldLock2 = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv2)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv2));
            }
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                boolean bl = false;
                object = this.releaseConnectionNoEvents$okhttp();
            }
            Socket socket = object;
            if (this.connection == null) {
                Socket socket2 = socket;
                if (socket2 != null) {
                    Util.closeQuietly(socket2);
                }
                this.eventListener.connectionReleased(this, connection);
            } else if (!(socket == null)) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
        }
        E result2 = this.timeoutExit(e);
        if (e != null) {
            Call call2 = this;
            E e2 = result2;
            Intrinsics.checkNotNull(e2);
            this.eventListener.callFailed(call2, e2);
        } else {
            this.eventListener.callEnd(this);
        }
        return result2;
    }

    @Nullable
    public final Socket releaseConnectionNoEvents$okhttp() {
        int index;
        List<Reference<RealCall>> calls;
        RealConnection connection;
        block6: {
            int n;
            RealConnection realConnection = this.connection;
            Intrinsics.checkNotNull((Object)realConnection);
            RealConnection $this$assertThreadHoldsLock$iv = connection = realConnection;
            boolean $i$f$assertThreadHoldsLock = false;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            List<Reference<RealCall>> $this$indexOfFirst$iv = calls = connection.getCalls();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Reference<RealCall>> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                Reference<RealCall> item$iv;
                Reference<RealCall> it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.get(), (Object)this)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (!(index != -1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        calls.remove(index);
        this.connection = null;
        if (calls.isEmpty()) {
            connection.setIdleAtNs$okhttp(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle(connection)) {
                return connection.socket();
            }
        }
        return null;
    }

    private final <E extends IOException> E timeoutExit(E cause) {
        if (this.timeoutEarlyExit) {
            return cause;
        }
        if (!this.timeout.exit()) {
            return cause;
        }
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return (E)e;
    }

    public final void timeoutEarlyExit() {
        if (!(!this.timeoutEarlyExit)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean closeExchange) {
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (!this.expectMoreExchanges) {
                boolean bl2 = false;
                String string = "released";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (closeExchange) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
        }
        this.interceptorScopedExchange = null;
    }

    private final Address createAddress(HttpUrl url2) {
        SSLSocketFactory sslSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (url2.isHttps()) {
            sslSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(url2.host(), url2.port(), this.client.dns(), this.client.socketFactory(), sslSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    public final boolean retryAfterFailure() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull((Object)exchangeFinder);
        return exchangeFinder.retryAfterFailure();
    }

    private final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl$okhttp();
    }

    @NotNull
    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\r\u001a\u00020\b2\n\u0010\f\u001a\u00060\u0000R\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00148\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010!\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"\u00a8\u0006#"}, d2={"Lokhttp3/internal/connection/RealCall$AsyncCall;", "Ljava/lang/Runnable;", "Lokhttp3/Callback;", "responseCallback", "<init>", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/Callback;)V", "Ljava/util/concurrent/ExecutorService;", "executorService", "", "executeOn", "(Ljava/util/concurrent/ExecutorService;)V", "Lokhttp3/internal/connection/RealCall;", "other", "reuseCallsPerHostFrom", "(Lokhttp3/internal/connection/RealCall$AsyncCall;)V", "run", "()V", "getCall", "()Lokhttp3/internal/connection/RealCall;", "call", "Ljava/util/concurrent/atomic/AtomicInteger;", "<set-?>", "callsPerHost", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCallsPerHost", "()Ljava/util/concurrent/atomic/AtomicInteger;", "", "getHost", "()Ljava/lang/String;", "host", "Lokhttp3/Request;", "getRequest", "()Lokhttp3/Request;", "request", "Lokhttp3/Callback;", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,551:1\n615#2,4:552\n409#2,9:556\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n*L\n494#1:552,4\n513#1:556,9\n*E\n"})
    public final class AsyncCall
    implements Runnable {
        @NotNull
        private final Callback responseCallback;
        @NotNull
        private volatile AtomicInteger callsPerHost;

        public AsyncCall(Callback responseCallback) {
            Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
            this.responseCallback = responseCallback;
            this.callsPerHost = new AtomicInteger(0);
        }

        @NotNull
        public final AtomicInteger getCallsPerHost() {
            return this.callsPerHost;
        }

        public final void reuseCallsPerHostFrom(@NotNull AsyncCall other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.callsPerHost = other.callsPerHost;
        }

        @NotNull
        public final String getHost() {
            return RealCall.this.getOriginalRequest().url().host();
        }

        @NotNull
        public final Request getRequest() {
            return RealCall.this.getOriginalRequest();
        }

        @NotNull
        public final RealCall getCall() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeOn(@NotNull ExecutorService executorService) {
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            Dispatcher $this$assertThreadDoesntHoldLock$iv = RealCall.this.getClient().dispatcher();
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            boolean success = false;
            try {
                executorService.execute(this);
                success = true;
            }
            catch (RejectedExecutionException e) {
                try {
                    InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                    ioException.initCause(e);
                    RealCall.this.noMoreExchanges$okhttp(ioException);
                    this.responseCallback.onFailure(RealCall.this, ioException);
                }
                catch (Throwable throwable) {
                    RealCall.this.getClient().dispatcher().finished$okhttp(this);
                    throw throwable;
                }
                RealCall.this.getClient().dispatcher().finished$okhttp(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void name$iv;
            String string = "OkHttp " + RealCall.this.redactedUrl$okhttp();
            RealCall realCall = RealCall.this;
            boolean $i$f$threadName = false;
            Thread currentThread$iv = Thread.currentThread();
            String oldName$iv = currentThread$iv.getName();
            currentThread$iv.setName((String)name$iv);
            try {
                boolean bl = false;
                boolean signalledCallback = false;
                realCall.timeout.enter();
                try {
                    Response response2 = realCall.getResponseWithInterceptorChain$okhttp();
                    signalledCallback = true;
                    this.responseCallback.onResponse(realCall, response2);
                }
                catch (IOException e) {
                    if (signalledCallback) {
                        Platform.Companion.get().log("Callback failure for " + realCall.toLoggableString(), 4, e);
                    } else {
                        this.responseCallback.onFailure(realCall, e);
                    }
                }
                catch (Throwable t) {
                    realCall.cancel();
                    if (!signalledCallback) {
                        IOException canceledException = new IOException("canceled due to " + t);
                        ExceptionsKt.addSuppressed((Throwable)canceledException, (Throwable)t);
                        this.responseCallback.onFailure(realCall, canceledException);
                    }
                    throw t;
                }
                finally {
                    realCall.getClient().dispatcher().finished$okhttp(this);
                }
            }
            finally {
                currentThread$iv.setName(oldName$iv);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/connection/RealCall$CallReference;", "Ljava/lang/ref/WeakReference;", "Lokhttp3/internal/connection/RealCall;", "referent", "", "callStackTrace", "<init>", "(Lokhttp3/internal/connection/RealCall;Ljava/lang/Object;)V", "Ljava/lang/Object;", "getCallStackTrace", "()Ljava/lang/Object;", "okhttp"})
    public static final class CallReference
    extends WeakReference<RealCall> {
        @Nullable
        private final Object callStackTrace;

        public CallReference(@NotNull RealCall referent, @Nullable Object callStackTrace) {
            Intrinsics.checkNotNullParameter((Object)referent, (String)"referent");
            super(referent);
            this.callStackTrace = callStackTrace;
        }

        @Nullable
        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }
    }
}

