/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u000b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0013\u0010\u0006J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lokhttp3/internal/io/FileSystem;", "", "Ljava/io/File;", "file", "Lokio/Sink;", "appendingSink", "(Ljava/io/File;)Lokio/Sink;", "", "delete", "(Ljava/io/File;)V", "directory", "deleteContents", "", "exists", "(Ljava/io/File;)Z", "from", "to", "rename", "(Ljava/io/File;Ljava/io/File;)V", "sink", "", "size", "(Ljava/io/File;)J", "Lokio/Source;", "source", "(Ljava/io/File;)Lokio/Source;", "Companion", "okhttp"})
public interface FileSystem {
    @NotNull
    public static final Companion Companion = okhttp3.internal.io.FileSystem$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final FileSystem SYSTEM = new Companion.SystemFileSystem();

    @NotNull
    public Source source(@NotNull File var1) throws FileNotFoundException;

    @NotNull
    public Sink sink(@NotNull File var1) throws FileNotFoundException;

    @NotNull
    public Sink appendingSink(@NotNull File var1) throws FileNotFoundException;

    public void delete(@NotNull File var1) throws IOException;

    public boolean exists(@NotNull File var1);

    public long size(@NotNull File var1);

    public void rename(@NotNull File var1, @NotNull File var2) throws IOException;

    public void deleteContents(@NotNull File var1) throws IOException;

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0001\u00a8\u0006\b"}, d2={"Lokhttp3/internal/io/FileSystem$Companion;", "", "<init>", "()V", "Lokhttp3/internal/io/FileSystem;", "SYSTEM", "Lokhttp3/internal/io/FileSystem;", "SystemFileSystem", "okhttp"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\bJ\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/io/FileSystem$Companion$SystemFileSystem;", "Lokhttp3/internal/io/FileSystem;", "<init>", "()V", "Ljava/io/File;", "file", "Lokio/Sink;", "appendingSink", "(Ljava/io/File;)Lokio/Sink;", "", "delete", "(Ljava/io/File;)V", "directory", "deleteContents", "", "exists", "(Ljava/io/File;)Z", "from", "to", "rename", "(Ljava/io/File;Ljava/io/File;)V", "sink", "", "size", "(Ljava/io/File;)J", "Lokio/Source;", "source", "(Ljava/io/File;)Lokio/Source;", "", "toString", "()Ljava/lang/String;", "okhttp"})
        private static final class SystemFileSystem
        implements FileSystem {
            @Override
            @NotNull
            public Source source(@NotNull File file2) throws FileNotFoundException {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return Okio.source(file2);
            }

            @Override
            @NotNull
            public Sink sink(@NotNull File file2) throws FileNotFoundException {
                Sink sink2;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                try {
                    sink2 = Okio.sink$default(file2, false, 1, null);
                }
                catch (FileNotFoundException _) {
                    file2.getParentFile().mkdirs();
                    sink2 = Okio.sink$default(file2, false, 1, null);
                }
                return sink2;
            }

            @Override
            @NotNull
            public Sink appendingSink(@NotNull File file2) throws FileNotFoundException {
                Sink sink2;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                try {
                    sink2 = Okio.appendingSink(file2);
                }
                catch (FileNotFoundException _) {
                    file2.getParentFile().mkdirs();
                    sink2 = Okio.appendingSink(file2);
                }
                return sink2;
            }

            @Override
            public void delete(@NotNull File file2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (!file2.delete() && file2.exists()) {
                    throw new IOException("failed to delete " + file2);
                }
            }

            @Override
            public boolean exists(@NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return file2.exists();
            }

            @Override
            public long size(@NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return file2.length();
            }

            @Override
            public void rename(@NotNull File from2, @NotNull File to) throws IOException {
                Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                this.delete(to);
                if (!from2.renameTo(to)) {
                    throw new IOException("failed to rename " + from2 + " to " + to);
                }
            }

            @Override
            public void deleteContents(@NotNull File directory) throws IOException {
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                File[] fileArray = directory.listFiles();
                if (fileArray == null) {
                    throw new IOException("not a readable directory: " + directory);
                }
                for (File file2 : fileArray) {
                    if (file2.isDirectory()) {
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        this.deleteContents(file2);
                    }
                    if (file2.delete()) continue;
                    throw new IOException("failed to delete " + file2);
                }
            }

            @NotNull
            public String toString() {
                return "FileSystem.SYSTEM";
            }
        }
    }
}

