/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001c\u001bB7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0018\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lokhttp3/internal/platform/Jdk8WithJettyBootPlatform;", "Lokhttp3/internal/platform/Platform;", "Ljava/lang/reflect/Method;", "putMethod", "getMethod", "removeMethod", "Ljava/lang/Class;", "clientProviderClass", "serverProviderClass", "<init>", "(Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/Class;Ljava/lang/Class;)V", "Ljavax/net/ssl/SSLSocket;", "sslSocket", "", "afterHandshake", "(Ljavax/net/ssl/SSLSocket;)V", "", "hostname", "", "Lokhttp3/Protocol;", "protocols", "configureTlsExtensions", "(Ljavax/net/ssl/SSLSocket;Ljava/lang/String;Ljava/util/List;)V", "getSelectedProtocol", "(Ljavax/net/ssl/SSLSocket;)Ljava/lang/String;", "Ljava/lang/Class;", "Ljava/lang/reflect/Method;", "Companion", "AlpnProvider", "okhttp"})
public final class Jdk8WithJettyBootPlatform
extends Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Method putMethod;
    @NotNull
    private final Method getMethod;
    @NotNull
    private final Method removeMethod;
    @NotNull
    private final Class<?> clientProviderClass;
    @NotNull
    private final Class<?> serverProviderClass;

    public Jdk8WithJettyBootPlatform(@NotNull Method putMethod, @NotNull Method getMethod, @NotNull Method removeMethod, @NotNull Class<?> clientProviderClass, @NotNull Class<?> serverProviderClass) {
        Intrinsics.checkNotNullParameter((Object)putMethod, (String)"putMethod");
        Intrinsics.checkNotNullParameter((Object)getMethod, (String)"getMethod");
        Intrinsics.checkNotNullParameter((Object)removeMethod, (String)"removeMethod");
        Intrinsics.checkNotNullParameter(clientProviderClass, (String)"clientProviderClass");
        Intrinsics.checkNotNullParameter(serverProviderClass, (String)"serverProviderClass");
        this.putMethod = putMethod;
        this.getMethod = getMethod;
        this.removeMethod = removeMethod;
        this.clientProviderClass = clientProviderClass;
        this.serverProviderClass = serverProviderClass;
    }

    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        List<String> names = Platform.Companion.alpnProtocolNames(protocols);
        try {
            Object[] objectArray = new Class[]{this.clientProviderClass, this.serverProviderClass};
            Object alpnProvider = Proxy.newProxyInstance(Platform.class.getClassLoader(), objectArray, (InvocationHandler)new AlpnProvider(names));
            objectArray = new Object[]{sslSocket, alpnProvider};
            this.putMethod.invoke(null, objectArray);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to set ALPN", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to set ALPN", e);
        }
    }

    @Override
    public void afterHandshake(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        try {
            Object[] objectArray = new Object[]{sslSocket};
            this.removeMethod.invoke(null, objectArray);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to remove ALPN", e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to remove ALPN", e);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        try {
            Object[] objectArray = new Object[]{sslSocket};
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.getMethod.invoke(null, objectArray));
            Intrinsics.checkNotNull((Object)invocationHandler, (String)"null cannot be cast to non-null type okhttp3.internal.platform.Jdk8WithJettyBootPlatform.AlpnProvider");
            AlpnProvider provider = (AlpnProvider)invocationHandler;
            if (!provider.getUnsupported() && provider.getSelected() == null) {
                Platform.log$default(this, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", 0, null, 6, null);
                return null;
            }
            return provider.getUnsupported() ? null : provider.getSelected();
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to get ALPN selected protocol", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to get ALPN selected protocol", e);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J2\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000bH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000fR$\u0010\u0010\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lokhttp3/internal/platform/Jdk8WithJettyBootPlatform$AlpnProvider;", "Ljava/lang/reflect/InvocationHandler;", "", "", "protocols", "<init>", "(Ljava/util/List;)V", "", "proxy", "Ljava/lang/reflect/Method;", "method", "", "args", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/util/List;", "selected", "Ljava/lang/String;", "getSelected", "()Ljava/lang/String;", "setSelected", "(Ljava/lang/String;)V", "", "unsupported", "Z", "getUnsupported", "()Z", "setUnsupported", "(Z)V", "okhttp"})
    private static final class AlpnProvider
    implements InvocationHandler {
        @NotNull
        private final List<String> protocols;
        private boolean unsupported;
        @Nullable
        private String selected;

        public AlpnProvider(@NotNull List<String> protocols) {
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            this.protocols = protocols;
        }

        public final boolean getUnsupported() {
            return this.unsupported;
        }

        public final void setUnsupported(boolean bl) {
            this.unsupported = bl;
        }

        @Nullable
        public final String getSelected() {
            return this.selected;
        }

        public final void setSelected(@Nullable String string) {
            this.selected = string;
        }

        @Override
        @Nullable
        public Object invoke(@NotNull Object proxy2, @NotNull Method method, @Nullable Object[] args) throws Throwable {
            Intrinsics.checkNotNullParameter((Object)proxy2, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Object[] objectArray = args;
            if (args == null) {
                objectArray = new Object[]{};
            }
            Object[] callArgs = objectArray;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (Intrinsics.areEqual((Object)methodName, (Object)"supports") && Intrinsics.areEqual(Boolean.TYPE, returnType)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"unsupported") && Intrinsics.areEqual(Void.TYPE, returnType)) {
                this.unsupported = true;
                return null;
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"protocols") && callArgs.length == 0) {
                return this.protocols;
            }
            if ((Intrinsics.areEqual((Object)methodName, (Object)"selectProtocol") || Intrinsics.areEqual((Object)methodName, (Object)"select")) && Intrinsics.areEqual(String.class, returnType) && callArgs.length == 1 && callArgs[0] instanceof List) {
                Object object = callArgs[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                List peerProtocols = (List)object;
                int i = 0;
                int n = peerProtocols.size();
                if (i <= n) {
                    while (true) {
                        Object e = peerProtocols.get(i);
                        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                        String protocol = (String)e;
                        if (this.protocols.contains(protocol)) {
                            this.selected = protocol;
                            return this.selected;
                        }
                        if (i == n) break;
                        ++i;
                    }
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((Intrinsics.areEqual((Object)methodName, (Object)"protocolSelected") || Intrinsics.areEqual((Object)methodName, (Object)"selected")) && callArgs.length == 1) {
                Object object = callArgs[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this.selected = (String)object;
                return null;
            }
            return method.invoke((Object)this, Arrays.copyOf(callArgs, callArgs.length));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/platform/Jdk8WithJettyBootPlatform$Companion;", "", "<init>", "()V", "Lokhttp3/internal/platform/Platform;", "buildIfSupported", "()Lokhttp3/internal/platform/Platform;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Platform buildIfSupported() {
            String jvmVersion = System.getProperty("java.specification.version", "unknown");
            try {
                Intrinsics.checkNotNullExpressionValue((Object)jvmVersion, (String)"jvmVersion");
                int version = Integer.parseInt(jvmVersion);
                if (version >= 9) {
                    return null;
                }
            }
            catch (NumberFormatException version) {
                // empty catch block
            }
            try {
                String alpnClassName = "io.github.quiltservertools.blockbotdiscord.libs.org.eclipse.jetty.alpn.ALPN";
                Class<?> alpnClass = Class.forName(alpnClassName, true, null);
                Class<?> providerClass = Class.forName(alpnClassName + "$Provider", true, null);
                Class<?> clientProviderClass = Class.forName(alpnClassName + "$ClientProvider", true, null);
                Class<?> serverProviderClass = Class.forName(alpnClassName + "$ServerProvider", true, null);
                Class[] classArray = new Class[]{SSLSocket.class, providerClass};
                Method putMethod = alpnClass.getMethod("put", classArray);
                Class[] classArray2 = new Class[]{SSLSocket.class};
                Method getMethod = alpnClass.getMethod("get", classArray2);
                Class[] classArray3 = new Class[]{SSLSocket.class};
                Method removeMethod = alpnClass.getMethod("remove", classArray3);
                Intrinsics.checkNotNullExpressionValue((Object)putMethod, (String)"putMethod");
                Intrinsics.checkNotNullExpressionValue((Object)getMethod, (String)"getMethod");
                Intrinsics.checkNotNullExpressionValue((Object)removeMethod, (String)"removeMethod");
                Intrinsics.checkNotNullExpressionValue(clientProviderClass, (String)"clientProviderClass");
                Intrinsics.checkNotNullExpressionValue(serverProviderClass, (String)"serverProviderClass");
                return new Jdk8WithJettyBootPlatform(putMethod, getMethod, removeMethod, clientProviderClass, serverProviderClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

