/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileHandle;
import okio.FileMetadata;
import okio.NioFileSystemFileHandle;
import okio.NioSystemFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\u0007*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J'\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010$\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010&\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b&\u0010%J\u001f\u0010(\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010+\u001a\u00020'2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010-\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b-\u0010)J\u001f\u0010.\u001a\u00020'2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b.\u0010,J\u000f\u0010/\u001a\u00020'H\u0016\u00a2\u0006\u0004\b/\u00100J\u000f\u00102\u001a\u000201H\u0016\u00a2\u0006\u0004\b2\u00103R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00104\u00a8\u00065"}, d2={"Lokio/NioFileSystemWrappingFileSystem;", "Lokio/NioSystemFileSystem;", "Ljava/nio/file/FileSystem;", "nioFileSystem", "<init>", "(Ljava/nio/file/FileSystem;)V", "Lokio/Path;", "Ljava/nio/file/Path;", "resolve", "(Lokio/Path;)Ljava/nio/file/Path;", "path", "canonicalize", "(Lokio/Path;)Lokio/Path;", "Lokio/FileMetadata;", "metadataOrNull", "(Lokio/Path;)Lokio/FileMetadata;", "dir", "", "list", "(Lokio/Path;)Ljava/util/List;", "listOrNull", "", "throwOnFailure", "(Lokio/Path;Z)Ljava/util/List;", "file", "Lokio/FileHandle;", "openReadOnly", "(Lokio/Path;)Lokio/FileHandle;", "mustCreate", "mustExist", "openReadWrite", "(Lokio/Path;ZZ)Lokio/FileHandle;", "Lokio/Source;", "source", "(Lokio/Path;)Lokio/Source;", "Lokio/Sink;", "sink", "(Lokio/Path;Z)Lokio/Sink;", "appendingSink", "", "createDirectory", "(Lokio/Path;Z)V", "target", "atomicMove", "(Lokio/Path;Lokio/Path;)V", "delete", "createSymlink", "close", "()V", "", "toString", "()Ljava/lang/String;", "Ljava/nio/file/FileSystem;", "okio"})
@SourceDebugExtension(value={"SMAP\nNioFileSystemWrappingFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioFileSystemWrappingFileSystem.kt\nokio/NioFileSystemWrappingFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,196:1\n1634#2,3:197\n1#3:200\n37#4:201\n36#4,3:202\n37#4:205\n36#4,3:206\n37#4:209\n36#4,3:210\n*S KotlinDebug\n*F\n+ 1 NioFileSystemWrappingFileSystem.kt\nokio/NioFileSystemWrappingFileSystem\n*L\n77#1:197,3\n104#1:201\n104#1:202,3\n125#1:205\n125#1:206,3\n138#1:209\n138#1:210,3\n*E\n"})
public final class NioFileSystemWrappingFileSystem
extends NioSystemFileSystem {
    @NotNull
    private final FileSystem nioFileSystem;

    public NioFileSystemWrappingFileSystem(@NotNull FileSystem nioFileSystem) {
        Intrinsics.checkNotNullParameter((Object)nioFileSystem, (String)"nioFileSystem");
        this.nioFileSystem = nioFileSystem;
    }

    private final java.nio.file.Path resolve(Path $this$resolve) {
        java.nio.file.Path path = this.nioFileSystem.getPath($this$resolve.toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @Override
    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            java.nio.file.Path path2 = this.resolve(path).toRealPath(new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toRealPath(...)");
            return Path.Companion.get$default(Path.Companion, path2, false, 1, null);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("no such file: " + path);
        }
    }

    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.metadataOrNull(this.resolve(path));
    }

    @Override
    @NotNull
    public List<Path> list(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List<Path> list2 = this.list(dir, true);
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    @Override
    @Nullable
    public List<Path> listOrNull(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.list(dir, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure) {
        void destination$iv;
        void $this$mapTo$iv;
        List list2;
        java.nio.file.Path nioDir = this.resolve(dir);
        try {
            list2 = PathsKt.listDirectoryEntries$default((java.nio.file.Path)nioDir, null, (int)1, null);
        }
        catch (Exception e) {
            if (throwOnFailure) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(nioDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    throw new FileNotFoundException("no such file: " + dir);
                }
                throw new IOException("failed to list " + dir);
            }
            return null;
        }
        List entries2 = list2;
        Iterable e = entries2;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void entry;
            java.nio.file.Path path = (java.nio.file.Path)item$iv;
            void var13_14 = destination$iv;
            boolean bl = false;
            var13_14.add(Path.Companion.get$default(Path.Companion, (java.nio.file.Path)entry, false, 1, null));
        }
        List result2 = (List)destination$iv;
        CollectionsKt.sort((List)result2);
        return result2;
    }

    @Override
    @NotNull
    public FileHandle openReadOnly(@NotNull Path file2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        try {
            object = new OpenOption[]{StandardOpenOption.READ};
            object = FileChannel.open(this.resolve(file2), object);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("no such file: " + file2);
        }
        Object channel2 = object;
        Intrinsics.checkNotNull((Object)channel2);
        return new NioFileSystemFileHandle(false, (FileChannel)channel2);
    }

    @Override
    @NotNull
    public FileHandle openReadWrite(@NotNull Path file2, boolean mustCreate, boolean mustExist) {
        Object object;
        List $i$a$-require-NioFileSystemWrappingFileSystem$openReadWrite$222;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(!mustCreate || !mustExist)) {
            boolean $i$a$-require-NioFileSystemWrappingFileSystem$openReadWrite$222 = false;
            String $i$a$-require-NioFileSystemWrappingFileSystem$openReadWrite$222 = "Cannot require mustCreate and mustExist at the same time.";
            throw new IllegalArgumentException($i$a$-require-NioFileSystemWrappingFileSystem$openReadWrite$222.toString());
        }
        List $this$openReadWrite_u24lambda_u242 = $i$a$-require-NioFileSystemWrappingFileSystem$openReadWrite$222 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$openReadWrite_u24lambda_u242.add(StandardOpenOption.READ);
        $this$openReadWrite_u24lambda_u242.add(StandardOpenOption.WRITE);
        if (mustCreate) {
            $this$openReadWrite_u24lambda_u242.add(StandardOpenOption.CREATE_NEW);
        } else if (!mustExist) {
            $this$openReadWrite_u24lambda_u242.add(StandardOpenOption.CREATE);
        }
        List openOptions = CollectionsKt.build((List)$i$a$-require-NioFileSystemWrappingFileSystem$openReadWrite$222);
        try {
            Collection $this$toTypedArray$iv = openOptions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new StandardOpenOption[0]);
            object = FileChannel.open(this.resolve(file2), Arrays.copyOf(object, ((StandardOpenOption[])object).length));
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("no such file: " + file2);
        }
        Object channel2 = object;
        Intrinsics.checkNotNull((Object)channel2);
        return new NioFileSystemFileHandle(true, (FileChannel)channel2);
    }

    @Override
    @NotNull
    public Source source(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream2 = Files.newInputStream(this.resolve(file2), Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
            return Okio.source(inputStream2);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("no such file: " + file2);
        }
    }

    @Override
    @NotNull
    public Sink sink(@NotNull Path file2, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = CollectionsKt.createListBuilder();
        OpenOption[] $this$sink_u24lambda_u243 = object;
        boolean bl = false;
        if (mustCreate) {
            $this$sink_u24lambda_u243.add(StandardOpenOption.CREATE_NEW);
        }
        List openOptions = CollectionsKt.build((List)object);
        try {
            object = this.resolve(file2);
            Collection $this$toTypedArray$iv = openOptions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$sink_u24lambda_u243 = thisCollection$iv.toArray(new StandardOpenOption[0]);
            $this$sink_u24lambda_u243 = Arrays.copyOf($this$sink_u24lambda_u243, $this$sink_u24lambda_u243.length);
            OutputStream outputStream2 = Files.newOutputStream((java.nio.file.Path)object, Arrays.copyOf($this$sink_u24lambda_u243, $this$sink_u24lambda_u243.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
            return Okio.sink(outputStream2);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("no such file: " + file2);
        }
    }

    @Override
    @NotNull
    public Sink appendingSink(@NotNull Path file2, boolean mustExist) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List $this$appendingSink_u24lambda_u244 = iterable = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$appendingSink_u24lambda_u244.add(StandardOpenOption.APPEND);
        if (!mustExist) {
            $this$appendingSink_u24lambda_u244.add(StandardOpenOption.CREATE);
        }
        List openOptions = CollectionsKt.build((List)iterable);
        iterable = this.resolve(file2);
        Collection $this$toTypedArray$iv = openOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        OpenOption[] openOptionArray = thisCollection$iv.toArray(new StandardOpenOption[0]);
        openOptionArray = Arrays.copyOf(openOptionArray, openOptionArray.length);
        OutputStream outputStream2 = Files.newOutputStream((java.nio.file.Path)iterable, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
        return Okio.sink(outputStream2);
    }

    @Override
    public void createDirectory(@NotNull Path dir, boolean mustCreate) {
        boolean alreadyExist;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        FileMetadata fileMetadata = this.metadataOrNull(dir);
        boolean bl = fileMetadata != null ? fileMetadata.isDirectory() : (alreadyExist = false);
        if (alreadyExist && mustCreate) {
            throw new IOException(dir + " already exists.");
        }
        try {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(this.resolve(dir), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
        }
        catch (IOException e) {
            if (alreadyExist) {
                return;
            }
            throw new IOException("failed to create directory: " + dir, e);
        }
    }

    @Override
    public void atomicMove(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        try {
            java.nio.file.Path path = this.resolve(source2);
            java.nio.file.Path path2 = this.resolve(target);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            throw new IOException("atomic move not supported");
        }
    }

    @Override
    public void delete(@NotNull Path path, boolean mustExist) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (Thread.interrupted()) {
                throw new InterruptedIOException("interrupted");
            }
            java.nio.file.Path nioPath = this.resolve(path);
            try {
                Files.delete(nioPath);
            }
            catch (NoSuchFileException e) {
                if (mustExist) {
                    throw new FileNotFoundException("no such file: " + path);
                }
            }
            catch (IOException e) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(nioPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block5;
                throw new IOException("failed to delete " + path);
            }
        }
    }

    @Override
    public void createSymlink(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createSymbolicLink(this.resolve(source2), this.resolve(target), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createSymbolicLink(...)");
    }

    @Override
    public void close() {
        this.nioFileSystem.close();
    }

    @Override
    @NotNull
    public String toString() {
        String string = Reflection.getOrCreateKotlinClass(this.nioFileSystem.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }
}

