/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris.disk;

import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.HWPartition;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class Prtvtoc {
    private static final String PRTVTOC_DEV_DSK = "prtvtoc /dev/dsk/";

    private Prtvtoc() {
    }

    public static List<HWPartition> queryPartitions(String mount, int major) {
        ArrayList<HWPartition> partList = new ArrayList<HWPartition>();
        List<String> prtvotc = ExecutingCommand.runNative(PRTVTOC_DEV_DSK + mount);
        if (prtvotc.size() > 1) {
            int bytesPerSector = 0;
            for (String line : prtvotc) {
                String type;
                String name2;
                String[] split;
                if (line.startsWith("*")) {
                    if (!line.endsWith("bytes/sector") || (split = ParseUtil.whitespaces.split(line)).length <= 0) continue;
                    bytesPerSector = ParseUtil.parseIntOrDefault(split[1], 0);
                    continue;
                }
                if (bytesPerSector <= 0 || (split = ParseUtil.whitespaces.split(line.trim())).length < 6 || "2".equals(split[0])) continue;
                String identification = mount + "s" + split[0];
                int minor = ParseUtil.parseIntOrDefault(split[0], 0);
                switch (ParseUtil.parseIntOrDefault(split[1], 0)) {
                    case 1: 
                    case 24: {
                        name2 = "boot";
                        break;
                    }
                    case 2: {
                        name2 = "root";
                        break;
                    }
                    case 3: {
                        name2 = "swap";
                        break;
                    }
                    case 4: {
                        name2 = "usr";
                        break;
                    }
                    case 5: {
                        name2 = "backup";
                        break;
                    }
                    case 6: {
                        name2 = "stand";
                        break;
                    }
                    case 7: {
                        name2 = "var";
                        break;
                    }
                    case 8: {
                        name2 = "home";
                        break;
                    }
                    case 9: {
                        name2 = "altsctr";
                        break;
                    }
                    case 10: {
                        name2 = "cache";
                        break;
                    }
                    case 11: {
                        name2 = "reserved";
                        break;
                    }
                    case 12: {
                        name2 = "system";
                        break;
                    }
                    case 14: {
                        name2 = "public region";
                        break;
                    }
                    case 15: {
                        name2 = "private region";
                        break;
                    }
                    default: {
                        name2 = "unknown";
                    }
                }
                switch (split[2]) {
                    case "00": {
                        type = "wm";
                        break;
                    }
                    case "10": {
                        type = "rm";
                        break;
                    }
                    case "01": {
                        type = "wu";
                        break;
                    }
                    default: {
                        type = "ru";
                    }
                }
                long partSize = (long)bytesPerSector * ParseUtil.parseLongOrDefault(split[4], 0L);
                String mountPoint = "";
                if (split.length > 6) {
                    mountPoint = split[6];
                }
                partList.add(new HWPartition(identification, name2, type, "", partSize, major, minor, mountPoint));
            }
        }
        return partList;
    }
}

