/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.client.renderer.item;

import appeng.client.render.cablebus.CubeBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import es.degrassi.appexp.block.ExperienceConverterBlock;
import es.degrassi.appexp.definition.AExpBlocks;
import es.degrassi.appexp.definition.AExpComponents;
import es.degrassi.appexp.definition.AExpConfig;
import es.degrassi.experiencelib.util.ClientExperienceUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@ParametersAreNonnullByDefault
public class ExperienceConverterItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final Minecraft mc = Minecraft.getInstance();
    public static final ExperienceConverterItemRenderer RENDERER = new ExperienceConverterItemRenderer();

    public ExperienceConverterItemRenderer() {
        super(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels());
    }

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockItem blockitem;
        Block block;
        Item item;
        BakedModel m = Minecraft.getInstance().getBlockRenderer().getBlockModel(((ExperienceConverterBlock)AExpBlocks.EXPERIENCE_CONVERTER.block()).defaultBlockState());
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        m = ClientHooks.handleCameraTransforms((PoseStack)poseStack, (BakedModel)m, (ItemDisplayContext)displayContext, (boolean)false);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        boolean flag1 = displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() && (item = stack.getItem()) instanceof BlockItem ? !((block = (blockitem = (BlockItem)item).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        for (BakedModel model : m.getRenderPasses(stack, flag1)) {
            for (RenderType rendertype : model.getRenderTypes(stack, flag1)) {
                VertexConsumer vertexconsumer;
                if (ExperienceConverterItemRenderer.hasAnimatedTexture(stack) && stack.hasFoil()) {
                    PoseStack.Pose posestack$pose = poseStack.last().copy();
                    if (displayContext == ItemDisplayContext.GUI) {
                        MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.5f);
                    } else if (displayContext.firstPerson()) {
                        MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.75f);
                    }
                    vertexconsumer = ItemRenderer.getCompassFoilBuffer((MultiBufferSource)buffer, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                } else {
                    vertexconsumer = flag1 ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.hasFoil()) : ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.hasFoil());
                }
                mc.getItemRenderer().renderModelLists(model, stack, light, overlay, poseStack, vertexconsumer);
            }
        }
        float percent = (float)((Long)stack.getOrDefault(AExpComponents.EXPERIENCE_AMOUNT, (Object)0L)).longValue() / (float)((Long)AExpConfig.get().XP_CONVERTER_CAPACITY.get()).longValue();
        if (percent <= 0.0f) {
            poseStack.popPose();
            return;
        }
        this.renderExperienceFill(percent, poseStack, buffer, light, overlay);
        poseStack.popPose();
    }

    private void renderExperienceFill(float percent, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.translucentMovingBlock());
        float fill = Mth.lerp((float)Mth.clamp((float)percent, (float)0.0f, (float)1.0f), (float)0.125f, (float)0.75f);
        CubeBuilder builder = new CubeBuilder();
        float y2 = Math.min(fill * 16.0f, Math.max(fill * 16.0f - 4.8828125E-4f, 0.0f));
        builder.setTexture(ClientExperienceUtils.EXPERIENCE.sprite());
        builder.addCube(1.0004883f, 4.8828125E-4f, 1.0004883f, 14.999512f, y2, 14.999512f);
        for (BakedQuad bakedQuad : builder.getOutput()) {
            vertexConsumer.putBulkData(poseStack.last(), bakedQuad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }

    private static boolean hasAnimatedTexture(ItemStack stack) {
        return stack.is(ItemTags.COMPASSES) || stack.is(Items.CLOCK);
    }
}

