/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.definition;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.definitions.BlockDefinition;
import es.degrassi.appexp.block.entity.ExperienceAcceptorEntity;
import es.degrassi.appexp.block.entity.ExperienceConverterEntity;
import es.degrassi.appexp.definition.AExpBlocks;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class AExpBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> DR = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"appex");
    public static final Supplier<BlockEntityType<ExperienceConverterEntity>> EXPERIENCE_CONVERTER = DR.register("experience_converter", () -> new BlockEntityType(ExperienceConverterEntity::new, Set.of(AExpBlocks.EXPERIENCE_CONVERTER.block()), null));
    public static final Supplier<BlockEntityType<ExperienceAcceptorEntity>> EXPERIENCE_ACCEPTOR = AExpBlockEntities.create("experience_acceptor", ExperienceAcceptorEntity.class, ExperienceAcceptorEntity::new, AExpBlocks.EXPERIENCE_ACCEPTOR);

    private AExpBlockEntities() {
    }

    private static <T extends AEBaseBlockEntity> Supplier<BlockEntityType<T>> create(String id, Class<T> entityClass, BlockEntityType.BlockEntitySupplier<T> supplier, BlockDefinition<? extends AEBaseEntityBlock<T>> block) {
        return DR.register(id, () -> {
            BlockEntityType type = BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{block.block()}).build(null);
            BlockEntityTicker clientTicker = null;
            BlockEntityTicker serverTicker = null;
            if (ClientTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
            }
            if (ServerTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
            }
            ((AEBaseEntityBlock)block.block()).setBlockEntity(entityClass, type, clientTicker, serverTicker);
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)block.asItem());
            return type;
        });
    }
}

