/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.item;

import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.AbstractPortableCell;
import es.degrassi.appexp.api.item.IExperienceCellItem;
import es.degrassi.appexp.definition.AExpMenus;
import es.degrassi.appexp.me.cell.ExperienceCellHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ExperiencePortableCellItem
extends AbstractPortableCell
implements IExperienceCellItem {
    private final StorageTier tier;

    public ExperiencePortableCellItem(StorageTier tier, Item.Properties props, int defaultColor) {
        super(AExpMenus.PORTABLE_EXPERIENCE_CELL_TYPE, props, defaultColor);
        this.tier = tier;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, context, lines, advancedTooltips);
        ExperienceCellHandler.INSTANCE.addCellInformationToTooltip(stack, lines);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return ExperienceCellHandler.INSTANCE.getTooltipImage(stack);
    }

    public ResourceLocation getRecipeId() {
        return Objects.requireNonNull(this.getRegistryName());
    }

    public double getChargeRate(ItemStack stack) {
        return 80.0 * (double)(Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack)) + 1);
    }

    @Override
    public long getTotalBytes() {
        return 50L * (long)Math.pow(4.0, this.tier.index() - 1);
    }

    @Override
    public double getIdleDrain() {
        return this.tier.idleDrain();
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)3, (arg_0, arg_1) -> ((ExperiencePortableCellItem)this).onUpgradesChanged(arg_0, arg_1));
    }

    @Generated
    public StorageTier getTier() {
        return this.tier;
    }
}

